/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.util.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1058;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import ru.dargen.evoplus.util.Util;

public final class Render {
    public static void scaledRunner(class_4587 matrixStack, float scale, BiConsumer<Integer, Integer> drawer) {
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, scale);
        drawer.accept((int)((float)Util.getWidth() / scale), (int)((float)Util.getHeight() / scale));
        matrixStack.method_22909();
    }

    public static void drawHorizontalLine(class_4587 matrices, int x, int y, int width, int color) {
        Render.fill(matrices, x, y, width, 1, color);
    }

    public static void drawVerticalLine(class_4587 matrices, int x, int y, int height, int color) {
        Render.fill(matrices, x, y, 1, height, color);
    }

    public static void fill(class_4587 matrixStack, int x, int y, int width, int height, int color) {
        Render.fill0(matrixStack, x, y, x + width, y + height, color);
    }

    private static void fill0(class_4587 matrices, int x1, int y1, int x2, int y2, int color) {
        int i;
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float f = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float h = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float j = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, 0.0f).method_22915(g, h, j, f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, 0.0f).method_22915(g, h, j, f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, 0.0f).method_22915(g, h, j, f).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, 0.0f).method_22915(g, h, j, f).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static void fillGradient(class_4587 matrixStack, int x, int y, int width, int height, int colorStart, int colorEnd) {
        Render.fillGradient0(matrixStack, x, y, x + width, y + height, colorStart, colorEnd, 0);
    }

    private static void fillGradient0(class_4587 matrices, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, int z) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        Render.fillGradient0(matrices.method_23760().method_23761(), bufferBuilder, startX, startY, endX, endY, z, colorStart, colorEnd);
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    private static void fillGradient0(Matrix4f matrix, class_287 builder, int startX, int startY, int endX, int endY, int z, int colorStart, int colorEnd) {
        float f = (float)class_5253.class_5254.method_27762((int)colorStart) / 255.0f;
        float g = (float)class_5253.class_5254.method_27765((int)colorStart) / 255.0f;
        float h = (float)class_5253.class_5254.method_27766((int)colorStart) / 255.0f;
        float i = (float)class_5253.class_5254.method_27767((int)colorStart) / 255.0f;
        float j = (float)class_5253.class_5254.method_27762((int)colorEnd) / 255.0f;
        float k = (float)class_5253.class_5254.method_27765((int)colorEnd) / 255.0f;
        float l = (float)class_5253.class_5254.method_27766((int)colorEnd) / 255.0f;
        float m = (float)class_5253.class_5254.method_27767((int)colorEnd) / 255.0f;
        builder.method_22918(matrix, (float)startX, (float)startY, (float)z).method_22915(g, h, i, f).method_1344();
        builder.method_22918(matrix, (float)startX, (float)endY, (float)z).method_22915(k, l, m, j).method_1344();
        builder.method_22918(matrix, (float)endX, (float)endY, (float)z).method_22915(k, l, m, j).method_1344();
        builder.method_22918(matrix, (float)endX, (float)startY, (float)z).method_22915(g, h, i, f).method_1344();
    }

    public static class_327 getTextRenderer() {
        return Util.getClient().field_1772;
    }

    public static int getStringWidth(String string) {
        return Render.getTextRenderer().method_1727(string);
    }

    public static int getStringHeight() {
        Objects.requireNonNull(Render.getTextRenderer());
        return 9;
    }

    public static void drawCenteredStringWithShadow(class_4587 matrixStack, String text, int centerX, int y, int color) {
        Render.getTextRenderer().method_1720(matrixStack, text, (float)(centerX - Render.getStringWidth(text) / 2), (float)y, color);
    }

    public static void drawCenteredString(class_4587 matrixStack, String text, int centerX, int y, int color) {
        Render.getTextRenderer().method_1729(matrixStack, text, (float)(centerX - Render.getStringWidth(text) / 2), (float)y, color);
    }

    public static void drawStringWithShadow(class_4587 matrices, String text, int x, int y, int color) {
        Render.getTextRenderer().method_1720(matrices, text, (float)x, (float)y, color);
    }

    public static void drawString(class_4587 matrices, String text, int x, int y, int color) {
        Render.getTextRenderer().method_1729(matrices, text, (float)x, (float)y, color);
    }

    public static void drawSprite(class_4587 matrices, int x, int y, int z, int width, int height, class_1058 sprite) {
        Render.drawTexturedQuad(matrices.method_23760().method_23761(), x, x + width, y, y + height, z, sprite.method_4594(), sprite.method_4577(), sprite.method_4593(), sprite.method_4575());
    }

    public static void drawTexture(class_4587 matrices, int x, int y, int u, int v, int width, int height) {
        Render.drawTexture(matrices, x, y, 0, u, v, width, height, 256, 256);
    }

    public static void drawTexture(class_4587 matrices, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        Render.drawTexture(matrices, x, x + width, y, y + height, z, width, height, u, v, textureWidth, textureHeight);
    }

    public static void drawTexture(class_4587 matrices, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        Render.drawTexture(matrices, x, x + width, y, y + height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void drawTexture(class_4587 matrices, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        Render.drawTexture(matrices, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
    }

    private static void drawTexture(class_4587 matrices, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
        Render.drawTexturedQuad(matrices.method_23760().method_23761(), x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
    }

    private static void drawTexturedQuad(Matrix4f matrix, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, (float)x0, (float)y0, (float)z).method_22913(u0, v0).method_1344();
        bufferBuilder.method_22918(matrix, (float)x0, (float)y1, (float)z).method_22913(u0, v1).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, (float)z).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y0, (float)z).method_22913(u1, v0).method_1344();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    public static class_918 getItemRenderer() {
        return Util.getClient().method_1480();
    }

    public static void drawItem(class_4587 matrixStack, class_1799 itemStack, int x, int y) {
        Render.getItemRenderer().method_4010(matrixStack, itemStack, x, y);
    }

    private Render() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

