/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.util.minecraft;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

public final class ItemUtil {
    private static final Constructor<class_2499> LIST_TAG_CONSTRUCTOR = ItemUtil.getListTagConstructor();

    public static String getDisplayName(class_1799 itemStack) {
        if (itemStack == null) {
            return null;
        }
        class_2561 text = itemStack.method_7964();
        return text == null ? null : text.getString();
    }

    public static List<String> getStringLore(class_1799 itemStack) {
        return ItemUtil.getTextLore(itemStack).stream().map(class_2561::getString).collect(Collectors.toList());
    }

    public static List<class_2561> getTextLore(class_1799 itemStack) {
        if (itemStack == null) {
            return Collections.emptyList();
        }
        class_2487 tag = itemStack.method_7941("display");
        class_2499 loreTag = tag.method_10554("Lore", 8);
        if (loreTag == null) {
            return Collections.emptyList();
        }
        return loreTag.stream().map(class_2520::method_10714).map(class_2561.class_2562::method_10877).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Constructor<class_2499> getListTagConstructor() {
        Constructor constructor = Arrays.stream(class_2499.class.getDeclaredConstructors()).filter(c -> c.getParameterCount() == 2).findFirst().get();
        constructor.setAccessible(true);
        return constructor;
    }

    public static void setStringLore(class_1799 itemStack, List<String> lore) {
        ItemUtil.setTextLore(itemStack, lore.stream().map(class_2561::method_30163).collect(Collectors.toList()));
    }

    public static void setTextLore(class_1799 itemStack, List<class_2561> lore) {
        if (itemStack == null || lore == null) {
            return;
        }
        class_2487 tag = itemStack.method_7911("display");
        class_2499 loreTag = LIST_TAG_CONSTRUCTOR.newInstance(lore.stream().map(class_2561.class_2562::method_10867).map(class_2519::method_23256).collect(Collectors.toList()), (byte)8);
        tag.method_10566("Lore", (class_2520)loreTag);
    }

    private ItemUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

