/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.util.formatter;

import java.util.HashMap;
import java.util.Map;
import ru.dargen.evoplus.util.Util;

public final class TimeFormatter {
    private static final Map<String, Long> MODIFIERS = new HashMap<String, Long>();
    private static final Long[] VALUES = new Long[]{2419200L, 604800L, 86400L, 3600L, 60L, 1L};
    private static final String[] FORMATS = new String[]{" %s \u043c\u0435\u0441.", " %s \u043d\u0435\u0434.", " %s \u0434\u043d.", " %s \u0447\u0430\u0441.", " %s \u043c\u0438\u043d.", " %s \u0441\u0435\u043a."};

    public static String formatText(long time) {
        Object result = "";
        if ((time /= 1000L) == 0L) {
            return "\u0441\u0435\u0439\u0447\u0430\u0441";
        }
        for (int i = 0; i < VALUES.length; ++i) {
            long temp = time / VALUES[i];
            if (temp < 1L) continue;
            result = (String)result + String.format(FORMATS[i], temp);
            time -= temp * VALUES[i];
        }
        return ((String)result).trim();
    }

    public static long parseText(String input) {
        long time = 0L;
        String[] args = input.split(" ");
        if (args.length % 2 != 0) {
            return 0L;
        }
        for (int i = 0; i < args.length; i += 2) {
            if (!Util.isInteger(args[i])) continue;
            int element = Integer.parseInt(args[i]);
            Long modifier = MODIFIERS.getOrDefault(args[i + 1], 1L);
            time += (long)element * modifier;
        }
        return time;
    }

    private TimeFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        MODIFIERS.put("\u0434\u043d.", 86400000L);
        MODIFIERS.put("\u0447.", 3600000L);
        MODIFIERS.put("\u043c\u0438\u043d.", 60000L);
        MODIFIERS.put("\u0441\u0435\u043a.", 1000L);
    }
}

