/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.util.formatter;

import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DoubleFormatter {
    public static final DecimalFormat FORMAT = new DecimalFormat("###.##");
    public static final Map<String, Double> MODIFIERS = new LinkedHashMap<String, Double>();

    public static String format(double number) {
        String suffix = "";
        for (Map.Entry<String, Double> modifierEntry : MODIFIERS.entrySet()) {
            if (!(number / modifierEntry.getValue() >= 1.0)) continue;
            suffix = modifierEntry.getKey();
            number /= modifierEntry.getValue().doubleValue();
            break;
        }
        String formatted = FORMAT.format(number);
        while (formatted.contains(".") && (formatted.endsWith("0") || formatted.endsWith("."))) {
            formatted = formatted.substring(0, formatted.length() - 1);
        }
        return formatted + suffix;
    }

    public static double parse(String number) {
        char end = number.charAt(number.length() - 1);
        if (Character.isDigit(end)) {
            return Double.parseDouble(number);
        }
        Double modifier = MODIFIERS.getOrDefault(String.valueOf(end).toUpperCase(), 1.0);
        double amount = Double.parseDouble(number.substring(0, number.length() - 1));
        return amount * modifier;
    }

    private DoubleFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        MODIFIERS.put("T", 1.0E12);
        MODIFIERS.put("B", 1.0E9);
        MODIFIERS.put("M", 1000000.0);
        MODIFIERS.put("K", 1000.0);
    }
}

