/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.util.diamondworld;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.diamondworld.DiamondWorldUtil;
import ru.dargen.evoplus.util.formatter.DoubleFormatter;

public class EvoStatistic {
    private static final AtomicBoolean UPDATE_STATE = new AtomicBoolean(false);
    protected boolean captured;
    protected int kills;
    protected int level;
    protected int shards;
    protected double money;
    protected double blocks;

    public EvoStatistic(EvoPlus mod) {
        mod.getTaskBus().runAsync(10L, 10L, task -> {
            List<String> scores = Util.getSidebarScores();
            UPDATE_STATE.set(true);
            try {
                if (!DiamondWorldUtil.isOnDiamondWorld() || scores.isEmpty()) {
                    UPDATE_STATE.set(false);
                } else {
                    this.kills = (int)this.parse(scores.get(4));
                    this.blocks = this.parse(scores.get(5));
                    this.level = (int)this.parse(scores.get(6));
                    this.shards = (int)this.parse(scores.get(7));
                    this.money = this.parse(scores.get(8));
                }
            }
            catch (Throwable t) {
                UPDATE_STATE.set(false);
            }
            this.captured = UPDATE_STATE.get();
            if (!this.captured) {
                this.kills = 0;
                this.blocks = 0.0;
                this.level = 0;
                this.shards = 0;
                this.money = 0.0;
            }
        });
    }

    private double parse(String score) {
        if ((score = Util.stripColor(score)) == null) {
            UPDATE_STATE.set(false);
            return 0.0;
        }
        String[] args = score.split(": ");
        if (args.length != 2) {
            UPDATE_STATE.set(false);
            return 0.0;
        }
        return DoubleFormatter.parse(args[1].replace("$", "").replace("I", "").replace("V", ""));
    }

    public boolean isCaptured() {
        return this.captured;
    }

    public int getKills() {
        return this.kills;
    }

    public int getLevel() {
        return this.level;
    }

    public int getShards() {
        return this.shards;
    }

    public double getMoney() {
        return this.money;
    }

    public double getBlocks() {
        return this.blocks;
    }
}

