/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.util.diamondworld;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_329;
import net.minecraft.class_355;
import net.minecraft.class_5251;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.event.chat.ChatReceiveEvent;
import ru.dargen.evoplus.event.server.ChangeServerEvent;
import ru.dargen.evoplus.event.server.DisconnectServerEvent;
import ru.dargen.evoplus.mixins.PlayerListHudAccessor;
import ru.dargen.evoplus.util.Util;

public final class DiamondWorldUtil {
    private static boolean onDiamondWorld = false;
    private static boolean onPrisonEvo = false;
    private static final List<Integer> ENCODED_COLOR_ALTERNATIVES;

    private static boolean isOnDiamondWorld0() {
        class_329 inGameHud = Util.getClient() == null ? null : Util.getClient().field_1705;
        class_355 playerListHud = inGameHud == null ? null : inGameHud.method_1750();
        class_2561 footerText = playerListHud == null ? null : ((PlayerListHudAccessor)playerListHud).getFooter();
        String footer = footerText == null ? "" : footerText.getString();
        return footer.contains("diamondworld.pro");
    }

    public static String encodeColoredText(class_2561 text) {
        class_5251 color = text.method_10866().method_10973();
        List<Object> buffer = Lists.newArrayList((Object[])new String[]{color == null ? "" : String.valueOf(ENCODED_COLOR_ALTERNATIVES.indexOf(color.method_27716()))});
        for (class_2561 sibling : text.method_10855()) {
            color = sibling.method_10866().method_10973();
            if (color == null || !ENCODED_COLOR_ALTERNATIVES.contains(color.method_27716())) continue;
            buffer.add(ENCODED_COLOR_ALTERNATIVES.indexOf(color.method_27716()) > 9 ? " " : "" + ENCODED_COLOR_ALTERNATIVES.indexOf(color.method_27716()));
        }
        buffer = String.join((CharSequence)"", (Iterable<? extends CharSequence>)buffer).isEmpty() ? Arrays.asList(text.getString().replaceAll("[ \u00a7]", "").replaceAll("d", " ")) : Arrays.asList(String.join((CharSequence)"", (Iterable<? extends CharSequence>)buffer).replaceAll("-1", "").split(" "));
        return buffer.stream().filter(num -> !num.isEmpty()).map(number -> String.valueOf((char)Integer.parseInt(number))).collect(Collectors.joining());
    }

    public static boolean isOnPrisonEvo() {
        return onPrisonEvo && DiamondWorldUtil.isOnDiamondWorld();
    }

    private DiamondWorldUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean isOnDiamondWorld() {
        return onDiamondWorld;
    }

    static {
        EvoPlus mod = EvoPlus.instance();
        mod.getEventBus().register(ChangeServerEvent.class, event -> {
            onPrisonEvo = false;
        });
        mod.getEventBus().register(DisconnectServerEvent.class, event -> {
            onPrisonEvo = false;
        });
        mod.getEventBus().register(ChangeServerEvent.class, event -> {
            if (DiamondWorldUtil.isOnDiamondWorld()) {
                Util.sendMessage("/modinfo server");
            }
        });
        mod.getEventBus().register(ChatReceiveEvent.class, event -> {
            try {
                String encoded = DiamondWorldUtil.encodeColoredText(event.getText());
                if (encoded.startsWith("[MODINFO")) {
                    boolean evoServerInfo = encoded.startsWith("[MODINFO-SERVER] PRISONEVO");
                    onPrisonEvo = DiamondWorldUtil.isOnDiamondWorld() && evoServerInfo;
                    event.setCancelled(true);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        mod.getTaskBus().runAsync(150L, 150L, task -> {
            onDiamondWorld = DiamondWorldUtil.isOnDiamondWorld0();
            if (onDiamondWorld) {
                Util.sendMessage("/modinfo server");
            }
        });
        mod.getTaskBus().runAsync(35L, 35L, task -> {
            if (DiamondWorldUtil.isOnPrisonEvo() && Util.getBossBarInfos().size() > 1 && Util.getSidebarObjective() == null) {
                Util.printMessage("\u00a77[\u00a7eEvo\u00a76Plus\u00a77] \u00a7r\u00a7c\u0414\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u043c\u043e\u0434\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u0441\u043e \u0441\u043a\u043e\u0440\u0431\u043e\u0440\u0434\u043e\u043c. \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u044e\u0441\u044c...");
                Util.sendMessage("/interface");
            }
        });
        ENCODED_COLOR_ALTERNATIVES = Arrays.asList(0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0xFF55FF);
    }
}

