/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.util.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.dargen.evoplus.EvoPlus;

public final class FileUtil {
    public static void setContent(String path, Consumer<BufferedWriter> writer) {
        FileUtil.checkAndMkdirFolder();
        File file = new File(EvoPlus.folder, path);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        writer.accept(bufferedWriter);
        bufferedWriter.flush();
        bufferedWriter.close();
    }

    public static void setStringContent(String path, String content) {
        FileUtil.setContent(path, writer -> {
            try {
                writer.write(content);
            }
            catch (Throwable t) {
                EvoPlus.instance().getLogger().error("Error while write to file", t);
            }
        });
    }

    public static <T> T getContent(String path, Function<BufferedReader, T> transform) {
        FileUtil.checkAndMkdirFolder();
        File file = new File(EvoPlus.folder, path);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        T result = transform.apply(bufferedReader);
        bufferedReader.close();
        return result;
    }

    public static String getStringContent(String path) {
        return FileUtil.getContent(path, reader -> reader.lines().collect(Collectors.joining("\n")));
    }

    public static void checkAndMkdirFolder() {
        if (!EvoPlus.folder.exists()) {
            EvoPlus.folder.mkdirs();
        }
        if (!EvoPlus.folder.isDirectory()) {
            EvoPlus.folder.delete();
            FileUtil.checkAndMkdirFolder();
        }
    }

    private FileUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

