/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1041;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2792;
import net.minecraft.class_310;
import net.minecraft.class_345;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_746;
import ru.dargen.evoplus.mixins.BossBarHudAccessor;

public final class Util {
    public static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[\\dA-FK-ORX]");

    public static class_310 getClient() {
        return class_310.method_1551();
    }

    public static class_1041 getWindow() {
        return Util.getClient() == null ? null : Util.getClient().method_22683();
    }

    public static class_437 getCurrentScreen() {
        return Util.getClient() == null ? null : Util.getClient().field_1755;
    }

    public static class_746 getPlayer() {
        return Util.getClient() == null ? null : Util.getClient().field_1724;
    }

    public static class_1937 getWorld() {
        return Util.getClient() == null ? null : Util.getClient().field_1687;
    }

    public static class_269 getScoreboard() {
        return Util.getWorld() == null ? null : Util.getWorld().method_8428();
    }

    public static class_266 getSidebarObjective() {
        return Util.getScoreboard() == null ? null : Util.getScoreboard().method_1189(1);
    }

    public static List<String> getSidebarScores() {
        class_266 sidebar = Util.getSidebarObjective();
        class_269 scoreboard = Util.getScoreboard();
        if (sidebar == null) {
            return Collections.emptyList();
        }
        LinkedList<class_267> scores = new LinkedList<class_267>(scoreboard.method_1184(sidebar));
        scores.sort(Comparator.comparingInt(class_267::method_1126));
        return scores.stream().filter(score -> score.method_1127().method_1113().equals(sidebar.method_1113())).map(score -> score.method_1129() + Util.getSuffixFromContainingScoreboardTeam(scoreboard, score.method_1129())).collect(Collectors.toList());
    }

    private static String getSuffixFromContainingScoreboardTeam(class_269 scoreboard, String member) {
        String suffix = null;
        for (class_268 team : scoreboard.method_1159()) {
            if (!team.method_1204().contains(member)) continue;
            suffix = team.method_1144().getString() + team.method_1136().getString();
            break;
        }
        return suffix == null ? "" : suffix;
    }

    public static Map<UUID, class_345> getBossBarInfos() {
        return Util.getClient() == null || Util.getClient().field_1705 == null ? Collections.emptyMap() : ((BossBarHudAccessor)Util.getClient().field_1705.method_1740()).getInfos();
    }

    public static boolean isOpenedScreen() {
        return Util.getCurrentScreen() != null;
    }

    public static boolean isKeyPressed(int keyCode) {
        return Util.getWindow() != null && class_3675.method_15987((long)Util.getWindow().method_4490(), (int)keyCode);
    }

    public static String getName() {
        return Util.getClient().method_1548().method_1676();
    }

    public static int getWidth() {
        return Util.getClient().method_22683().method_4486();
    }

    public static int getHeight() {
        return Util.getClient().method_22683().method_4502();
    }

    public static int rgb(int r, int g, int b) {
        return Util.rgb(r, g, b, 255);
    }

    public static int rgb(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static void printMessage(String text) {
        if (Util.getPlayer() != null) {
            Util.getPlayer().method_7353(class_2561.method_30163((String)text), false);
        }
    }

    public static void sendMessage(String text) {
        if (Util.getPlayer() != null) {
            Util.getPlayer().field_3944.method_45729(text);
        }
    }

    public static String stripColor(String input) {
        if (input == null) {
            return null;
        }
        return STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    public static void sendPacket(class_2596<class_2792> packet) {
        if (Util.getPlayer() != null) {
            Util.getPlayer().field_3944.method_2883(packet);
        }
    }

    public static boolean isInteger(String number) {
        try {
            Integer.parseInt(number);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

