/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.task;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.task.LaterTask;
import ru.dargen.evoplus.task.ScheduledTask;
import ru.dargen.evoplus.task.Task;

public class TaskBus {
    private final Thread thread;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Map<Integer, Task> tasks = new ConcurrentHashMap<Integer, Task>();
    private final EvoPlus mod;

    public TaskBus(EvoPlus mod) {
        this.mod = mod;
        this.thread = new Thread(this::run);
        this.thread.setName("TaskBus-Thread");
        this.thread.start();
    }

    public Task run(long delay, long period, Consumer<Task> handler) {
        ScheduledTask task = new ScheduledTask(delay, period, true, handler);
        this.tasks.put(task.getId(), task);
        return task;
    }

    public Task runAsync(long delay, long period, Consumer<Task> handler) {
        ScheduledTask task = new ScheduledTask(delay, period, false, handler);
        this.tasks.put(task.getId(), task);
        return task;
    }

    public Task runLater(long delay, Consumer<Task> handler) {
        LaterTask task = new LaterTask(delay, true, handler);
        this.tasks.put(task.getId(), task);
        return task;
    }

    public Task runLaterAsync(long delay, Consumer<Task> handler) {
        LaterTask task = new LaterTask(delay, false, handler);
        this.tasks.put(task.getId(), task);
        return task;
    }

    private void run() {
        while (!this.thread.isInterrupted()) {
            long currentTick = System.currentTimeMillis();
            this.tasks.values().forEach(task -> {
                if (task.isSync()) {
                    try {
                        task.tick(currentTick);
                    }
                    catch (Throwable t) {
                        this.mod.getLogger().error("Error while running task " + task.getId(), t);
                    }
                } else {
                    this.executor.execute(() -> {
                        try {
                            task.tick(currentTick);
                        }
                        catch (Throwable t) {
                            this.mod.getLogger().error("Error while running task " + task.getId(), t);
                        }
                    });
                }
            });
            Thread.sleep(50L);
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Map<Integer, Task> getTasks() {
        return this.tasks;
    }

    public EvoPlus getMod() {
        return this.mod;
    }
}

