/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.task;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.task.Task;

public abstract class BaseTask
implements Task {
    private static final AtomicInteger ID = new AtomicInteger();
    protected final int id = ID.incrementAndGet();
    protected final boolean sync;
    protected final Consumer<Task> handler;

    @Override
    public boolean isCancelled() {
        return !EvoPlus.instance().getTaskBus().getTasks().containsKey(this.id);
    }

    @Override
    public boolean cancel() {
        if (this.isCancelled()) {
            return false;
        }
        EvoPlus.instance().getTaskBus().getTasks().remove(this.id);
        return true;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isSync() {
        return this.sync;
    }

    @Override
    public Consumer<Task> getHandler() {
        return this.handler;
    }

    public BaseTask(boolean sync, Consumer<Task> handler) {
        this.sync = sync;
        this.handler = handler;
    }
}

