/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.notify;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.event.render.HudRenderEvent;
import ru.dargen.evoplus.event.server.DisconnectServerEvent;
import ru.dargen.evoplus.feature.Feature;
import ru.dargen.evoplus.notify.Notification;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.minecraft.Render;

public class NotificationsManager {
    private final int SPLIT_Y = 7;
    private final int SPLIT_X = 7;
    private final int H_SIZE = 50;
    private final int W_SIZE = 120;
    protected final List<Notification> notifications = new LinkedList<Notification>();

    public NotificationsManager(EvoPlus mod) {
        mod.getEventBus().register(HudRenderEvent.class, event -> {
            class_4587 matrixStack = event.getMatrixStack();
            this.render(matrixStack, Util.getWidth(), Util.getHeight());
        });
        mod.getEventBus().register(DisconnectServerEvent.class, event -> this.notifications.clear());
    }

    public Notification notify(Notification.Type type, String name, int duration, String message) {
        Notification notify = new Notification(type, name, duration, message);
        notify.x = Util.getWidth();
        notify.y = 7;
        this.notifications.add(notify);
        if (Util.getPlayer() != null && Feature.MISC_FEATURE.getNotifySound().getValue().booleanValue()) {
            Util.getPlayer().method_5783((class_3414)class_3417.field_14622.comp_349(), 1.0f, 1.0f);
        }
        return notify;
    }

    public Notification notify(Notification.Type type, String name, int duration) {
        return this.notify(type, name, duration, null);
    }

    public void remove(Notification notify) {
        this.notifications.remove(notify);
    }

    public void render(class_4587 matrixStack, int width, int height) {
        int y = 7;
        int w = width;
        for (int i = 0; i < this.notifications.size(); ++i) {
            double percent;
            Notification notification = this.notifications.get(i);
            int max = Math.min(width - 120 - 7, width - 15 - Render.getStringWidth(notification.name) - 7);
            int maxSize = Math.max(120, 15 + Render.getStringWidth(notification.name));
            if (notification.message != null) {
                max = Math.min(max, width - 10 - notification.message.length() - 7);
                maxSize = Math.max(10 + notification.message.length(), maxSize);
            }
            if (!notification.enabled && (notification.x -= 4) <= max) {
                notification.x = max;
                notification.enabled = true;
            }
            long delay = notification.getDuration() * 1000L;
            long end = notification.getStartTime() + delay;
            long current = System.currentTimeMillis();
            long left = end - current;
            boolean is = current >= end;
            double d = percent = notification.enabled && !is ? 1.0 - (double)left / (double)delay : 1.0;
            if (is && (notification.x += 4) >= w) {
                this.remove(notification);
                continue;
            }
            if (notification.y < y) {
                notification.y += Math.min(3, y - notification.y);
                if (notification.y > y) {
                    notification.y = y;
                }
            }
            if (notification.y > y) {
                notification.y -= Math.min(3, notification.y - y);
                if (notification.y < y) {
                    notification.y = y;
                }
            }
            int hsize = 10 + Render.getStringHeight() * (notification.message != null ? 2 : 0);
            if (y <= height) {
                Render.fill(matrixStack, notification.x, notification.y, maxSize, hsize, Util.rgb(56, 149, 198, 150));
                Render.fill(matrixStack, notification.x, notification.y, 4, hsize, notification.type.color);
                Render.fill(matrixStack, notification.x + 4, notification.y, (int)((double)maxSize * percent), 4, Util.rgb(26, 93, 128, 220));
                Render.drawStringWithShadow(matrixStack, notification.name, notification.x + 10, notification.y + 5, -1);
                if (notification.message != null) {
                    Render.drawStringWithShadow(matrixStack, notification.message, notification.x + 15, notification.y + 8 + Render.getStringHeight(), -1);
                }
            }
            y += 7 + hsize;
        }
    }

    public int getSPLIT_Y() {
        Objects.requireNonNull(this);
        return 7;
    }

    public int getSPLIT_X() {
        Objects.requireNonNull(this);
        return 7;
    }

    public int getH_SIZE() {
        return this.H_SIZE;
    }

    public int getW_SIZE() {
        return this.W_SIZE;
    }

    public List<Notification> getNotifications() {
        return this.notifications;
    }
}

