/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.gui.element;

import net.minecraft.class_4587;
import ru.dargen.evoplus.gui.GuiElement;
import ru.dargen.evoplus.util.minecraft.Render;

public class GuiRectangleElement
implements GuiElement {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int color;
    protected boolean visible = true;
    protected boolean hovered;
    protected boolean enabled = true;

    public GuiRectangleElement(int color, int x, int y, int width, int height) {
        this.color = color;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public GuiElement setPos(int x, int y) {
        return this.setX(x).setY(y);
    }

    @Override
    public GuiElement setSize(int width, int height) {
        return this.setWidth(width).setHeight(height);
    }

    @Override
    public void keyTyped(int i) {
    }

    @Override
    public void draw(class_4587 matrixStack, int mx, int my) {
        if (!this.visible) {
            this.hovered = false;
        } else {
            Render.fill(matrixStack, this.x, this.y, this.width, this.height, this.color);
        }
    }

    @Override
    public void mouseReleased(int button, int mx, int my) {
    }

    @Override
    public void mousePressed(int button, int mx, int my) {
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public GuiRectangleElement setX(int x) {
        this.x = x;
        return this;
    }

    @Override
    public GuiRectangleElement setY(int y) {
        this.y = y;
        return this;
    }

    @Override
    public GuiRectangleElement setWidth(int width) {
        this.width = width;
        return this;
    }

    @Override
    public GuiRectangleElement setHeight(int height) {
        this.height = height;
        return this;
    }

    public GuiRectangleElement setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    public GuiRectangleElement setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiRectangleElement setHovered(boolean hovered) {
        this.hovered = hovered;
        return this;
    }

    @Override
    public GuiRectangleElement setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiRectangleElement)) {
            return false;
        }
        GuiRectangleElement other = (GuiRectangleElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getColor() != other.getColor()) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isHovered() != other.isHovered()) {
            return false;
        }
        return this.isEnabled() == other.isEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiRectangleElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + this.getColor();
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isHovered() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "GuiRectangleElement(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", color=" + this.getColor() + ", visible=" + this.isVisible() + ", hovered=" + this.isHovered() + ", enabled=" + this.isEnabled() + ")";
    }
}

