/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.gui.element;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_4587;
import ru.dargen.evoplus.gui.GuiElement;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.minecraft.Render;

public class GuiRangeElement<T>
implements GuiElement {
    public static int BOX_COLOR = Util.rgb(23, 24, 31);
    public static int HOVERED_CURSOR_COLOR = Util.rgb(56, 57, 65);
    public static int CURSOR_COLOR = Util.rgb(38, 72, 140);
    protected List<T> elements;
    protected Consumer<GuiRangeElement<T>> actionHandler;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean visible = true;
    protected boolean hovered;
    protected boolean enabled = true;
    private double step = 0.0;
    private double[] cursorPositions = new double[0];
    private int currentPosition = 0;
    private boolean captured;

    public GuiRangeElement(List<T> elements, int x, int y, int width, int height, Consumer<GuiRangeElement<T>> actionHandler, int selectedIndex) {
        this.elements = elements;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.actionHandler = actionHandler;
        this.currentPosition = selectedIndex;
        this.update();
    }

    public GuiRangeElement(List<T> elements, int x, int y, int width, int height, Consumer<GuiRangeElement<T>> actionHandler) {
        this(elements, x, y, width, height, actionHandler, 0);
    }

    public GuiRangeElement(List<T> elements, int x, int y, int width, int height, int selectedIndex) {
        this(elements, x, y, width, height, null, selectedIndex);
    }

    public GuiRangeElement(List<T> elements, int x, int y, int width, int height) {
        this(elements, x, y, width, height, null);
    }

    public GuiElement setCursorPositions(int x, int y) {
        return ((GuiRangeElement)this.setX(x)).setY(y);
    }

    @Override
    public GuiElement setPos(int x, int y) {
        return ((GuiRangeElement)this.setX(x)).setY(y);
    }

    @Override
    public GuiElement setSize(int width, int height) {
        return ((GuiRangeElement)this.setWidth(width)).setHeight(height);
    }

    public GuiRangeElement<T> update() {
        this.step = (double)this.width / (double)this.elements.size();
        this.cursorPositions = new double[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            this.cursorPositions[i] = this.step * (double)(i + 1) + (i == this.elements.size() - 1 ? (double)this.width - (double)this.elements.size() * this.step : 0.0);
        }
        return this;
    }

    public T getCurrentElement() {
        return this.elements.get(this.currentPosition);
    }

    public GuiRangeElement<T> setElements(List<T> elements) {
        this.elements = elements;
        return this.update();
    }

    @Override
    public GuiRangeElement<T> setWidth(int width) {
        this.width = width;
        return this.update();
    }

    @Override
    public void draw(class_4587 matrixStack, int mx, int my) {
        if (this.elements.isEmpty() || !this.visible) {
            this.hovered = false;
        } else {
            if (this.captured) {
                if (mx < this.getX() || mx > this.x + this.width) {
                    this.currentPosition = mx < this.getX() ? 0 : this.cursorPositions.length - 1;
                } else {
                    double last = this.x - 1;
                    for (int i = 0; i < this.cursorPositions.length; ++i) {
                        double cx = this.cursorPositions[i] + (double)this.x;
                        if ((double)mx >= last && (double)mx <= cx) {
                            this.currentPosition = i;
                            if (this.actionHandler == null) break;
                            this.actionHandler.accept(this);
                            break;
                        }
                        last = cx + 1.0;
                    }
                }
            }
            Render.fill(matrixStack, this.x, this.y, this.width, this.height, BOX_COLOR);
            Render.fill(matrixStack, (int)((double)this.x + this.cursorPositions[this.currentPosition] - this.step / 2.0 - 2.0), this.y - 1, 4, 1 + this.height, this.hovered ? HOVERED_CURSOR_COLOR : CURSOR_COLOR);
            Render.drawCenteredStringWithShadow(matrixStack, this.getCurrentElement().toString(), this.x + this.width / 2, this.y + this.height / 2 - Render.getStringHeight() / 2, -1);
        }
    }

    @Override
    public void keyTyped(int i) {
    }

    @Override
    public void mouseReleased(int button, int mx, int my) {
        this.captured = false;
    }

    @Override
    public void mousePressed(int button, int mx, int my) {
        this.captured = this.isInside(mx, my);
    }

    public List<T> getElements() {
        return this.elements;
    }

    public Consumer<GuiRangeElement<T>> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public double getStep() {
        return this.step;
    }

    public double[] getCursorPositions() {
        return this.cursorPositions;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public boolean isCaptured() {
        return this.captured;
    }

    public GuiRangeElement<T> setActionHandler(Consumer<GuiRangeElement<T>> actionHandler) {
        this.actionHandler = actionHandler;
        return this;
    }

    @Override
    public GuiRangeElement<T> setX(int x) {
        this.x = x;
        return this;
    }

    @Override
    public GuiRangeElement<T> setY(int y) {
        this.y = y;
        return this;
    }

    @Override
    public GuiRangeElement<T> setHeight(int height) {
        this.height = height;
        return this;
    }

    @Override
    public GuiRangeElement<T> setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiRangeElement<T> setHovered(boolean hovered) {
        this.hovered = hovered;
        return this;
    }

    @Override
    public GuiRangeElement<T> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GuiRangeElement<T> setStep(double step) {
        this.step = step;
        return this;
    }

    public GuiRangeElement<T> setCursorPositions(double[] cursorPositions) {
        this.cursorPositions = cursorPositions;
        return this;
    }

    public GuiRangeElement<T> setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
        return this;
    }

    public GuiRangeElement<T> setCaptured(boolean captured) {
        this.captured = captured;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiRangeElement)) {
            return false;
        }
        GuiRangeElement other = (GuiRangeElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isHovered() != other.isHovered()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (Double.compare(this.getStep(), other.getStep()) != 0) {
            return false;
        }
        if (this.getCurrentPosition() != other.getCurrentPosition()) {
            return false;
        }
        if (this.isCaptured() != other.isCaptured()) {
            return false;
        }
        List<T> this$elements = this.getElements();
        List<T> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        Consumer<GuiRangeElement<T>> this$actionHandler = this.getActionHandler();
        Consumer<GuiRangeElement<T>> other$actionHandler = other.getActionHandler();
        if (this$actionHandler == null ? other$actionHandler != null : !this$actionHandler.equals(other$actionHandler)) {
            return false;
        }
        return Arrays.equals(this.getCursorPositions(), other.getCursorPositions());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiRangeElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isHovered() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $step = Double.doubleToLongBits(this.getStep());
        result = result * 59 + (int)($step >>> 32 ^ $step);
        result = result * 59 + this.getCurrentPosition();
        result = result * 59 + (this.isCaptured() ? 79 : 97);
        List<T> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        Consumer<GuiRangeElement<T>> $actionHandler = this.getActionHandler();
        result = result * 59 + ($actionHandler == null ? 43 : $actionHandler.hashCode());
        result = result * 59 + Arrays.hashCode(this.getCursorPositions());
        return result;
    }

    public String toString() {
        return "GuiRangeElement(elements=" + this.getElements() + ", actionHandler=" + this.getActionHandler() + ", x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", visible=" + this.isVisible() + ", hovered=" + this.isHovered() + ", enabled=" + this.isEnabled() + ", step=" + this.getStep() + ", cursorPositions=" + Arrays.toString(this.getCursorPositions()) + ", currentPosition=" + this.getCurrentPosition() + ", captured=" + this.isCaptured() + ")";
    }
}

