/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.gui.element;

import net.minecraft.class_4587;
import ru.dargen.evoplus.gui.GuiElement;
import ru.dargen.evoplus.util.minecraft.Render;

public class GuiLabelElement
implements GuiElement {
    protected String text;
    protected float scale = 1.0f;
    protected int x;
    protected int y;
    protected boolean visible = true;
    protected boolean hovered;
    protected boolean enabled = true;

    public GuiLabelElement(String text, int x, int y, float scale) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.scale = scale;
    }

    public GuiLabelElement(String text, int x, int y) {
        this(text, x, y, 1.0f);
    }

    @Override
    public GuiElement setPos(int x, int y) {
        return this.setX(x).setY(y);
    }

    @Override
    public GuiElement setSize(int width, int height) {
        return this;
    }

    @Override
    public void draw(class_4587 matrixStack, int mx, int my) {
        if (!this.visible) {
            this.hovered = false;
        } else {
            this.hovered = this.isInside(mx, my);
            Render.scaledRunner(matrixStack, this.scale, (__, ___) -> Render.drawStringWithShadow(matrixStack, this.text, (int)((float)this.x / this.scale), (int)((float)this.y / this.scale), -1));
        }
    }

    @Override
    public void keyTyped(int i) {
    }

    @Override
    public void mouseReleased(int button, int mx, int my) {
    }

    @Override
    public void mousePressed(int button, int mx, int my) {
    }

    @Override
    public GuiElement setWidth(int width) {
        return this;
    }

    @Override
    public GuiElement setHeight(int height) {
        return this;
    }

    @Override
    public int getWidth() {
        return Render.getStringWidth(this.text == null ? "" : this.text);
    }

    @Override
    public int getHeight() {
        return Render.getStringHeight();
    }

    public String getText() {
        return this.text;
    }

    public float getScale() {
        return this.scale;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public GuiLabelElement setText(String text) {
        this.text = text;
        return this;
    }

    public GuiLabelElement setScale(float scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public GuiLabelElement setX(int x) {
        this.x = x;
        return this;
    }

    @Override
    public GuiLabelElement setY(int y) {
        this.y = y;
        return this;
    }

    @Override
    public GuiLabelElement setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiLabelElement setHovered(boolean hovered) {
        this.hovered = hovered;
        return this;
    }

    @Override
    public GuiLabelElement setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiLabelElement)) {
            return false;
        }
        GuiLabelElement other = (GuiLabelElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getScale(), other.getScale()) != 0) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isHovered() != other.isHovered()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiLabelElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getScale());
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isHovered() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "GuiLabelElement(text=" + this.getText() + ", scale=" + this.getScale() + ", x=" + this.getX() + ", y=" + this.getY() + ", visible=" + this.isVisible() + ", hovered=" + this.isHovered() + ", enabled=" + this.isEnabled() + ")";
    }
}

