/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.gui.element;

import java.util.function.Consumer;
import net.minecraft.class_4587;
import ru.dargen.evoplus.gui.GuiElement;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.minecraft.Render;

public class GuiButtonElement
implements GuiElement {
    public static int DEFAULT_COLOR = Util.rgb(23, 24, 31);
    public static int HOVERED_COLOR = Util.rgb(56, 57, 65);
    public static int DISABLED_COLOR = Util.rgb(38, 72, 140);
    protected String text;
    protected Consumer<GuiButtonElement> clickHandler;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean visible = true;
    protected boolean hovered;
    protected boolean enabled = true;

    public GuiButtonElement(String text, int x, int y, int width, int height, Consumer<GuiButtonElement> clickHandler) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.clickHandler = clickHandler;
    }

    public GuiButtonElement(String text, int x, int y, int width, int height) {
        this(text, x, y, width, height, null);
    }

    @Override
    public GuiElement setPos(int x, int y) {
        return this.setX(x).setY(y);
    }

    @Override
    public GuiElement setSize(int width, int height) {
        return this.setWidth(width).setHeight(height);
    }

    @Override
    public void draw(class_4587 matrixStack, int mx, int my) {
        if (!this.visible) {
            this.hovered = false;
        } else {
            this.hovered = this.isInside(mx, my);
            Render.fill(matrixStack, this.x, this.y, this.width, this.height, this.enabled ? (this.hovered ? HOVERED_COLOR : DEFAULT_COLOR) : DISABLED_COLOR);
            Render.drawCenteredStringWithShadow(matrixStack, this.text, this.x + this.width / 2, this.y + this.height / 2 - Render.getStringHeight() / 2, -1);
        }
    }

    @Override
    public void keyTyped(int i) {
    }

    @Override
    public void mouseReleased(int button, int mx, int my) {
    }

    @Override
    public void mousePressed(int button, int mx, int my) {
        if (this.clickHandler != null && this.hovered && this.enabled) {
            this.clickHandler.accept(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public Consumer<GuiButtonElement> getClickHandler() {
        return this.clickHandler;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public GuiButtonElement setText(String text) {
        this.text = text;
        return this;
    }

    public GuiButtonElement setClickHandler(Consumer<GuiButtonElement> clickHandler) {
        this.clickHandler = clickHandler;
        return this;
    }

    @Override
    public GuiButtonElement setX(int x) {
        this.x = x;
        return this;
    }

    @Override
    public GuiButtonElement setY(int y) {
        this.y = y;
        return this;
    }

    @Override
    public GuiButtonElement setWidth(int width) {
        this.width = width;
        return this;
    }

    @Override
    public GuiButtonElement setHeight(int height) {
        this.height = height;
        return this;
    }

    @Override
    public GuiButtonElement setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiButtonElement setHovered(boolean hovered) {
        this.hovered = hovered;
        return this;
    }

    @Override
    public GuiButtonElement setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiButtonElement)) {
            return false;
        }
        GuiButtonElement other = (GuiButtonElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isHovered() != other.isHovered()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        Consumer<GuiButtonElement> this$clickHandler = this.getClickHandler();
        Consumer<GuiButtonElement> other$clickHandler = other.getClickHandler();
        return !(this$clickHandler == null ? other$clickHandler != null : !this$clickHandler.equals(other$clickHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiButtonElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isHovered() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        Consumer<GuiButtonElement> $clickHandler = this.getClickHandler();
        result = result * 59 + ($clickHandler == null ? 43 : $clickHandler.hashCode());
        return result;
    }

    public String toString() {
        return "GuiButtonElement(text=" + this.getText() + ", clickHandler=" + this.getClickHandler() + ", x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", visible=" + this.isVisible() + ", hovered=" + this.isHovered() + ", enabled=" + this.isEnabled() + ")";
    }
}

