/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.setting;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import io.netty.util.internal.ConcurrentSet;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.feature.setting.Setting;
import ru.dargen.evoplus.gui.GuiElement;

public class SetConfig<T>
implements Setting<Set<T>> {
    protected final Type hashSetType = new TypeToken<HashSet<T>>(this.getClass()){}.getType();
    protected final Set<T> value = new ConcurrentSet();
    protected final String name;
    protected final String id;

    @Override
    public GuiElement getElement() {
        return null;
    }

    @Override
    public void load(JsonElement jsonElement) {
        Set set = (Set)EvoPlus.instance().getGson().fromJson(jsonElement.getAsString(), this.hashSetType);
        if (set != null) {
            this.value.addAll(set);
        }
    }

    @Override
    public JsonElement unload() {
        return EvoPlus.instance().getGson().toJsonTree((Object)EvoPlus.instance().getGson().toJson(this.value));
    }

    @Override
    public boolean isDrawable() {
        return false;
    }

    SetConfig(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public static <T> SetConfigBuilder<T> builder() {
        return new SetConfigBuilder();
    }

    public Type getHashSetType() {
        return this.hashSetType;
    }

    @Override
    public Set<T> getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetConfig)) {
            return false;
        }
        SetConfig other = (SetConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Type this$hashSetType = this.getHashSetType();
        Type other$hashSetType = other.getHashSetType();
        if (this$hashSetType == null ? other$hashSetType != null : !this$hashSetType.equals(other$hashSetType)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $hashSetType = this.getHashSetType();
        result = result * 59 + ($hashSetType == null ? 43 : $hashSetType.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "SetConfig(hashSetType=" + this.getHashSetType() + ", value=" + (Set)this.getValue() + ", name=" + this.getName() + ", id=" + this.getId() + ")";
    }

    public static class SetConfigBuilder<T> {
        private String name;
        private String id;

        SetConfigBuilder() {
        }

        public SetConfigBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public SetConfigBuilder<T> id(String id) {
            this.id = id;
            return this;
        }

        public SetConfig<T> build() {
            return new SetConfig(this.name, this.id);
        }

        public String toString() {
            return "SetConfig.SetConfigBuilder(name=" + this.name + ", id=" + this.id + ")";
        }
    }
}

