/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.setting;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.function.Consumer;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.feature.setting.Setting;
import ru.dargen.evoplus.gui.GuiElement;
import ru.dargen.evoplus.gui.element.GuiRangeElement;

public class RangeSetting<T>
implements Setting<T> {
    protected final String name;
    protected final String id;
    protected final List<T> elements;
    protected int index;
    protected Consumer<RangeSetting<T>> changeHandler;

    @Override
    public T getValue() {
        return this.elements.get(this.fixIndex());
    }

    @Override
    public GuiElement getElement() {
        return new GuiRangeElement<T>(this.elements, 0, 0, 100, 20, element -> {
            this.index = element.getCurrentPosition();
            this.fixIndex();
            if (this.changeHandler != null) {
                this.changeHandler.accept(this);
            }
        }, this.fixIndex());
    }

    @Override
    public void load(JsonElement jsonElement) {
        int index = jsonElement.getAsInt();
        boolean changed = index != this.index;
        this.index = index;
        this.fixIndex();
        if (changed && this.changeHandler != null) {
            this.changeHandler.accept(this);
        }
    }

    @Override
    public JsonElement unload() {
        return EvoPlus.instance().getPrettyGson().toJsonTree((Object)this.fixIndex());
    }

    protected int fixIndex() {
        if (this.index < 0) {
            this.index = 0;
        } else if (this.index >= this.elements.size()) {
            this.index = this.elements.size() - 1;
        }
        return this.index;
    }

    private static <T> int $default$index() {
        return 0;
    }

    private static <T> Consumer<RangeSetting<T>> $default$changeHandler() {
        return null;
    }

    RangeSetting(String name, String id, List<T> elements, int index, Consumer<RangeSetting<T>> changeHandler) {
        this.name = name;
        this.id = id;
        this.elements = elements;
        this.index = index;
        this.changeHandler = changeHandler;
    }

    public static <T> RangeSettingBuilder<T> builder() {
        return new RangeSettingBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<T> getElements() {
        return this.elements;
    }

    public int getIndex() {
        return this.index;
    }

    public Consumer<RangeSetting<T>> getChangeHandler() {
        return this.changeHandler;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setChangeHandler(Consumer<RangeSetting<T>> changeHandler) {
        this.changeHandler = changeHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeSetting)) {
            return false;
        }
        RangeSetting other = (RangeSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<T> this$elements = this.getElements();
        List<T> other$elements = other.getElements();
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        Consumer<RangeSetting<T>> this$changeHandler = this.getChangeHandler();
        Consumer<RangeSetting<T>> other$changeHandler = other.getChangeHandler();
        return !(this$changeHandler == null ? other$changeHandler != null : !this$changeHandler.equals(other$changeHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RangeSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<T> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        Consumer<RangeSetting<T>> $changeHandler = this.getChangeHandler();
        result = result * 59 + ($changeHandler == null ? 43 : $changeHandler.hashCode());
        return result;
    }

    public String toString() {
        return "RangeSetting(name=" + this.getName() + ", id=" + this.getId() + ", elements=" + this.getElements() + ", index=" + this.getIndex() + ", changeHandler=" + this.getChangeHandler() + ")";
    }

    public static class RangeSettingBuilder<T> {
        private String name;
        private String id;
        private List<T> elements;
        private boolean index$set;
        private int index$value;
        private boolean changeHandler$set;
        private Consumer<RangeSetting<T>> changeHandler$value;

        RangeSettingBuilder() {
        }

        public RangeSettingBuilder<T> name(String name) {
            this.name = name;
            return this;
        }

        public RangeSettingBuilder<T> id(String id) {
            this.id = id;
            return this;
        }

        public RangeSettingBuilder<T> elements(List<T> elements) {
            this.elements = elements;
            return this;
        }

        public RangeSettingBuilder<T> index(int index) {
            this.index$value = index;
            this.index$set = true;
            return this;
        }

        public RangeSettingBuilder<T> changeHandler(Consumer<RangeSetting<T>> changeHandler) {
            this.changeHandler$value = changeHandler;
            this.changeHandler$set = true;
            return this;
        }

        public RangeSetting<T> build() {
            int index$value = this.index$value;
            if (!this.index$set) {
                index$value = RangeSetting.$default$index();
            }
            Consumer<RangeSetting<T>> changeHandler$value = this.changeHandler$value;
            if (!this.changeHandler$set) {
                changeHandler$value = RangeSetting.$default$changeHandler();
            }
            return new RangeSetting<T>(this.name, this.id, this.elements, index$value, changeHandler$value);
        }

        public String toString() {
            return "RangeSetting.RangeSettingBuilder(name=" + this.name + ", id=" + this.id + ", elements=" + this.elements + ", index$value=" + this.index$value + ", changeHandler$value=" + this.changeHandler$value + ")";
        }
    }
}

