/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.setting;

import com.google.gson.JsonElement;
import java.util.function.Consumer;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.feature.setting.Setting;
import ru.dargen.evoplus.gui.GuiElement;
import ru.dargen.evoplus.gui.element.GuiButtonElement;

public class BooleanSetting
implements Setting<Boolean> {
    protected final String name;
    protected final String id;
    protected Boolean value;
    protected Consumer<BooleanSetting> changeHandler;

    @Override
    public GuiElement getElement() {
        return new GuiButtonElement(this.toString(), 0, 0, 100, 20, element -> {
            this.value = this.value == false;
            element.setText(this.toString());
            if (this.changeHandler != null) {
                this.changeHandler.accept(this);
            }
        });
    }

    public String toString() {
        return this.value != false ? "\u00a7a\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u043e" : "\u00a7c\u0412\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e";
    }

    @Override
    public void load(JsonElement jsonElement) {
        boolean value = jsonElement.getAsBoolean();
        boolean changed = value != this.value;
        this.value = value;
        if (changed && this.changeHandler != null) {
            this.changeHandler.accept(this);
        }
    }

    @Override
    public JsonElement unload() {
        return EvoPlus.instance().getPrettyGson().toJsonTree((Object)this.value);
    }

    private static Boolean $default$value() {
        return true;
    }

    private static Consumer<BooleanSetting> $default$changeHandler() {
        return null;
    }

    BooleanSetting(String name, String id, Boolean value, Consumer<BooleanSetting> changeHandler) {
        this.name = name;
        this.id = id;
        this.value = value;
        this.changeHandler = changeHandler;
    }

    public static BooleanSettingBuilder builder() {
        return new BooleanSettingBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public Consumer<BooleanSetting> getChangeHandler() {
        return this.changeHandler;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public void setChangeHandler(Consumer<BooleanSetting> changeHandler) {
        this.changeHandler = changeHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BooleanSetting)) {
            return false;
        }
        BooleanSetting other = (BooleanSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$value = this.getValue();
        Boolean other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Consumer<BooleanSetting> this$changeHandler = this.getChangeHandler();
        Consumer<BooleanSetting> other$changeHandler = other.getChangeHandler();
        return !(this$changeHandler == null ? other$changeHandler != null : !this$changeHandler.equals(other$changeHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BooleanSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Consumer<BooleanSetting> $changeHandler = this.getChangeHandler();
        result = result * 59 + ($changeHandler == null ? 43 : $changeHandler.hashCode());
        return result;
    }

    public static class BooleanSettingBuilder {
        private String name;
        private String id;
        private boolean value$set;
        private Boolean value$value;
        private boolean changeHandler$set;
        private Consumer<BooleanSetting> changeHandler$value;

        BooleanSettingBuilder() {
        }

        public BooleanSettingBuilder name(String name) {
            this.name = name;
            return this;
        }

        public BooleanSettingBuilder id(String id) {
            this.id = id;
            return this;
        }

        public BooleanSettingBuilder value(Boolean value) {
            this.value$value = value;
            this.value$set = true;
            return this;
        }

        public BooleanSettingBuilder changeHandler(Consumer<BooleanSetting> changeHandler) {
            this.changeHandler$value = changeHandler;
            this.changeHandler$set = true;
            return this;
        }

        public BooleanSetting build() {
            Boolean value$value = this.value$value;
            if (!this.value$set) {
                value$value = BooleanSetting.$default$value();
            }
            Consumer<BooleanSetting> changeHandler$value = this.changeHandler$value;
            if (!this.changeHandler$set) {
                changeHandler$value = BooleanSetting.$default$changeHandler();
            }
            return new BooleanSetting(this.name, this.id, value$value, changeHandler$value);
        }

        public String toString() {
            return "BooleanSetting.BooleanSettingBuilder(name=" + this.name + ", id=" + this.id + ", value$value=" + this.value$value + ", changeHandler$value=" + this.changeHandler$value + ")";
        }
    }
}

