/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.impl.stats.booster;

import ru.dargen.evoplus.feature.impl.stats.booster.BoosterType;

public class BoosterInfo {
    protected BoosterType type = BoosterType.NONE;
    protected volatile long lastBreak = 0L;
    protected volatile int blocks = 0;

    public void handleBreak() {
        if (!this.isActive()) {
            this.blocks = 0;
            this.type = BoosterType.NONE;
        }
        ++this.blocks;
        this.update();
    }

    public void cancelBreak() {
        if (--this.blocks < 0) {
            this.blocks = 0;
        }
    }

    public void update() {
        this.lastBreak = System.currentTimeMillis();
    }

    public boolean isStopBreak() {
        return System.currentTimeMillis() - this.lastBreak >= 1000L;
    }

    public BoosterType getNextType() {
        return this.isMax() ? null : BoosterType.values()[this.type.ordinal() + 1];
    }

    public int getNextBlocks() {
        return this.isMax() ? 0 : this.getNextType().getBlocks();
    }

    public boolean isCompleted() {
        return this.getNextBlocks() <= this.blocks;
    }

    public long getRightTime() {
        return this.lastBreak + this.getTimeOut() - System.currentTimeMillis();
    }

    public boolean isMax() {
        return this.type.ordinal() == BoosterType.values().length - 1;
    }

    public boolean isActive() {
        return System.currentTimeMillis() - this.lastBreak < this.getTimeOut();
    }

    public long getTimeOut() {
        return (long)Math.min(this.blocks / 200 + 4, 40) * 1000L;
    }

    public void setType(BoosterType type) {
        this.type = type;
    }

    public void setLastBreak(long lastBreak) {
        this.lastBreak = lastBreak;
    }

    public void setBlocks(int blocks) {
        this.blocks = blocks;
    }

    public BoosterType getType() {
        return this.type;
    }

    public long getLastBreak() {
        return this.lastBreak;
    }

    public int getBlocks() {
        return this.blocks;
    }
}

