/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.impl.stats;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.util.internal.ConcurrentSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.event.chat.ChatReceiveEvent;
import ru.dargen.evoplus.event.interact.BlockBreakEvent;
import ru.dargen.evoplus.event.inventory.InventoryOpenEvent;
import ru.dargen.evoplus.event.inventory.InventorySlotUpdateEvent;
import ru.dargen.evoplus.feature.Feature;
import ru.dargen.evoplus.feature.impl.stats.booster.BoosterInfo;
import ru.dargen.evoplus.feature.impl.stats.booster.BoosterType;
import ru.dargen.evoplus.feature.impl.stats.level.LevelRequire;
import ru.dargen.evoplus.feature.impl.stats.level.RequireType;
import ru.dargen.evoplus.feature.setting.BooleanSetting;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.diamondworld.DiamondWorldUtil;
import ru.dargen.evoplus.util.formatter.DoubleFormatter;
import ru.dargen.evoplus.util.minecraft.ItemUtil;

public class StatsFeature
extends Feature {
    protected final Cache<class_2338, Long> latestBlocks = CacheBuilder.newBuilder().expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();
    protected final Set<LevelRequire> requires = new ConcurrentSet();
    protected final BoosterInfo boosterInfo = new BoosterInfo();
    protected long eliteEndTime = 0L;
    protected BooleanSetting levelRequires = BooleanSetting.builder().id("level-requires").name("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c").build();
    protected BooleanSetting runesStats = BooleanSetting.builder().id("runes-stats").name("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u043e\u0431\u0449\u0435\u0439 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0440\u0443\u043d").build();
    protected BooleanSetting booster = BooleanSetting.builder().id("booster").name("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e \u0431\u0443\u0441\u0442\u0435\u0440\u0435 \u043e\u0442 \u043a\u043e\u043f\u0430\u043d\u0438\u044f").build();

    public StatsFeature() {
        super("\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430", "statistic");
        this.register();
    }

    @Override
    public void onRegister(EvoPlus mod) {
        mod.getEventBus().register(InventorySlotUpdateEvent.class, event -> {
            InventoryOpenEvent openEvent = event.getOpenEvent();
            class_1799 item = event.getStack();
            if (openEvent == null || item == null || item.method_7909() == class_1802.field_8162 || !DiamondWorldUtil.isOnPrisonEvo()) {
                return;
            }
            String itemName = Util.stripColor(ItemUtil.getDisplayName(item));
            if (itemName.contains("\u041f\u043e\u0434\u043d\u044f\u0442\u044c \u0443\u0440\u043e\u0432\u0435\u043d\u044c")) {
                Set requires = ItemUtil.getStringLore(item).stream().map(Util::stripColor).filter(line -> line.contains(":")).map(line -> {
                    String[] info = line.substring(2).split(": ");
                    String name = info[0].trim();
                    String requireAmount = info[1].split("/")[1].trim();
                    RequireType type = RequireType.getByName(name);
                    if (type == null) {
                        return null;
                    }
                    return new LevelRequire(name, type, DoubleFormatter.parse(requireAmount));
                }).filter(Objects::nonNull).collect(Collectors.toSet());
                this.requires.clear();
                this.requires.addAll(requires);
            }
        });
        mod.getEventBus().register(ChatReceiveEvent.class, event -> {
            String text = Util.stripColor(event.getText().getString());
            if (!DiamondWorldUtil.isOnPrisonEvo()) {
                return;
            }
            if (this.booster.getValue().booleanValue() && text.startsWith("\u0412\u044b \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u043a\u043e\u043c\u0431\u043e. \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0439\u0442\u0435 \u043a\u043e\u043f\u0430\u0442\u044c, \u0447\u0442\u043e\u0431\u044b \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u0443\u0441\u0442\u0435\u0440 \u0434\u0435\u043d\u0435\u0433 ")) {
                double multiplier = Double.parseDouble(text.substring(69));
                BoosterType type = BoosterType.getByMultiplier(multiplier);
                if (type == null) {
                    return;
                }
                this.boosterInfo.setType(type);
                this.boosterInfo.update();
            }
        });
        mod.getEventBus().register(BlockBreakEvent.class, event -> {
            if (!event.getBlockState().method_26215() && DiamondWorldUtil.isOnPrisonEvo()) {
                this.latestBlocks.put((Object)event.getPosition(), (Object)this.getBoosterInfo().getLastBreak());
                this.getBoosterInfo().handleBreak();
            }
        });
    }

    public Cache<class_2338, Long> getLatestBlocks() {
        return this.latestBlocks;
    }

    public Set<LevelRequire> getRequires() {
        return this.requires;
    }

    public BoosterInfo getBoosterInfo() {
        return this.boosterInfo;
    }

    public long getEliteEndTime() {
        return this.eliteEndTime;
    }

    public BooleanSetting getLevelRequires() {
        return this.levelRequires;
    }

    public BooleanSetting getRunesStats() {
        return this.runesStats;
    }

    public BooleanSetting getBooster() {
        return this.booster;
    }
}

