/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.impl.staff;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.event.interact.InteractItemEvent;
import ru.dargen.evoplus.event.inventory.InventorySlotUpdateEvent;
import ru.dargen.evoplus.event.render.HudRenderEvent;
import ru.dargen.evoplus.feature.Feature;
import ru.dargen.evoplus.feature.impl.staff.StaffInfo;
import ru.dargen.evoplus.feature.impl.staff.StaffType;
import ru.dargen.evoplus.feature.setting.BooleanSetting;
import ru.dargen.evoplus.feature.setting.RangeSetting;
import ru.dargen.evoplus.notify.Notification;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.common.CollectionUtil;
import ru.dargen.evoplus.util.diamondworld.DiamondWorldUtil;
import ru.dargen.evoplus.util.minecraft.ItemUtil;
import ru.dargen.evoplus.util.minecraft.Render;

public class StaffTimerFeature
extends Feature {
    protected Map<StaffType, StaffInfo> infoMap = new ConcurrentHashMap<StaffType, StaffInfo>();
    protected BooleanSetting render = BooleanSetting.builder().name("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435").id("render").build();
    protected BooleanSetting messageOnReady = BooleanSetting.builder().name("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0438 \u0437\u0430\u0434\u0435\u0440\u0436\u043a\u0438").id("message").value(false).build();
    protected BooleanSetting notifyOnReady = BooleanSetting.builder().name("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0438 \u0437\u0430\u0434\u0435\u0440\u0436\u043a\u0438").id("notify").build();
    protected RangeSetting<Integer> perkLevel = RangeSetting.builder().name("\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u043f\u0435\u0440\u043a\u0430 \"\u0427\u0430\u0440\u043e\u0434\u0435\u0439\"").id("magic-level").elements(CollectionUtil.intRange(0, 2, 1)).build();

    public StaffTimerFeature() {
        super("\u0422\u0430\u0439\u043c\u0435\u0440 \u043f\u043e\u0441\u043e\u0445\u043e\u0432", "staff-timer");
        this.register();
    }

    @Override
    public void onRegister(EvoPlus mod) {
        mod.getTaskBus().runAsync(10L, 10L, task -> {
            for (StaffType type : StaffType.values()) {
                if (this.hasCooldown(type) || this.infoMap.remove((Object)type) == null || !DiamondWorldUtil.isOnPrisonEvo()) continue;
                if (this.notifyOnReady.getValue().booleanValue()) {
                    mod.getNotifyManager().notify(Notification.Type.CONFIRM, "\u00a7a\u041f\u043e\u0441\u043e\u0445 \u0441\u043d\u043e\u0432\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d", 3, "\u00a7e" + type.getName());
                }
                if (!this.messageOnReady.getValue().booleanValue()) continue;
                Util.printMessage("\u00a77[\u00a7eEvo\u00a76Plus\u00a77] \u00a7r\u00a7a\u041f\u043e\u0441\u043e\u0445 \u0441\u043d\u043e\u0432\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d: \u00a7e" + type.getName());
            }
        });
        mod.getEventBus().register(InventorySlotUpdateEvent.class, event -> {
            String displayName;
            class_1799 itemStack = event.getStack();
            String string = displayName = itemStack == null ? null : class_124.method_539((String)ItemUtil.getDisplayName(itemStack));
            if (displayName == null || !displayName.contains("\u0427\u0430\u0440\u043e\u0434\u0435\u0439")) {
                return;
            }
            int level = ItemUtil.getStringLore(itemStack).stream().anyMatch(line -> line.contains("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u043a\u0430\u0447\u043a\u0430")) ? 2 : (displayName.contains("2") ? 1 : 0);
            this.perkLevel.setIndex(level);
        });
        mod.getEventBus().register(InteractItemEvent.class, event -> {
            StaffType type;
            class_1799 itemStack = event.getItemStack();
            StaffType staffType = type = itemStack == null ? null : StaffType.getByStack(itemStack);
            if (itemStack == null || type == null || this.hasCooldown(type)) {
                return;
            }
            Optional<String> durationLine = ItemUtil.getStringLore(itemStack).stream().map(Util::stripColor).filter(line -> line.contains("\u041f\u0435\u0440\u0435\u0437\u0430\u0440\u044f\u0434\u043a\u0430")).findFirst();
            if (!durationLine.isPresent()) {
                return;
            }
            String durationInfo = durationLine.get().split(": ")[1];
            float rawDuration = Float.parseFloat(durationInfo.substring(0, durationInfo.length() - 1));
            int duration = Math.round((1.0f - (float)this.perkLevel.getValue().intValue() * 0.05f) * rawDuration);
            this.putCooldown(type, duration);
        });
        mod.getEventBus().register(HudRenderEvent.class, event -> {
            if (!this.render.getValue().booleanValue() || !DiamondWorldUtil.isOnPrisonEvo()) {
                return;
            }
            int startX = Util.getWidth() / 2 + 95;
            int height = Util.getHeight();
            class_4587 matrixStack = event.getMatrixStack();
            for (StaffType type : StaffType.values()) {
                StaffInfo info = this.infoMap.get((Object)type);
                String state = this.hasCooldown(type) ? "\u00a76" + (info.getUsedTime() + info.getDelay() - System.currentTimeMillis()) / 1000L : "\u00a72\u00a7l\u2713";
                Render.drawCenteredString(matrixStack, state, startX + 20 * type.ordinal() + 10, height - 24 - Render.getStringHeight() / 2, -1);
                Render.drawItem(matrixStack, type.getRenderItem(), startX + 20 * type.ordinal(), height - 20);
                if (this.hasCooldown(type) || this.infoMap.remove((Object)type) == null) continue;
                if (this.notifyOnReady.getValue().booleanValue()) {
                    mod.getNotifyManager().notify(Notification.Type.CONFIRM, "\u00a7a\u041f\u043e\u0441\u043e\u0445 \u0441\u043d\u043e\u0432\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d", 3, "\u00a7e" + type.getName());
                }
                if (!this.messageOnReady.getValue().booleanValue()) continue;
                Util.printMessage("\u00a77[\u00a7eEvo\u00a76Plus\u00a77] \u00a7r\u00a7a\u041f\u043e\u0441\u043e\u0445 \u0441\u043d\u043e\u0432\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d: \u00a7e" + type.getName());
            }
        });
    }

    public boolean hasCooldown(StaffType type) {
        StaffInfo info = this.infoMap.get((Object)type);
        return info != null && info.getUsedTime() + info.getDelay() >= System.currentTimeMillis();
    }

    public void putCooldown(StaffType type, int duration) {
        this.infoMap.put(type, new StaffInfo(System.currentTimeMillis(), (long)duration * 1000L));
    }

    public Map<StaffType, StaffInfo> getInfoMap() {
        return this.infoMap;
    }

    public BooleanSetting getRender() {
        return this.render;
    }

    public BooleanSetting getMessageOnReady() {
        return this.messageOnReady;
    }

    public BooleanSetting getNotifyOnReady() {
        return this.notifyOnReady;
    }

    public RangeSetting<Integer> getPerkLevel() {
        return this.perkLevel;
    }
}

