/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.impl.boss;

import java.util.Arrays;
import java.util.List;
import ru.dargen.evoplus.util.Util;

public enum BossType {
    KRIEGER("\u041a\u0440\u0438\u0433\u0435\u0440", 15, 1200),
    SLIME("\u0421\u043b\u0438\u0437\u0435\u043d\u044c", 20, 1800),
    STEEL_GUARD("\u0421\u0442\u0430\u043b\u044c\u043d\u043e\u0439 \u0421\u0442\u0440\u0430\u0436", 25, 2100),
    NIGHTMARE("\u041a\u043e\u0448\u043c\u0430\u0440", 30, 2700),
    TWINS("\u0411\u043b\u0438\u0437\u043d\u0435\u0446\u044b", 35, 7200),
    FIRE_LORD("\u041f\u043e\u0432\u0435\u043b\u0438\u0442\u0435\u043b\u044c \u041e\u0433\u043d\u044f", 40, 3600),
    SPIDER("\u041f\u0430\u0443\u0447\u0438\u0445\u0430", 45, 10800),
    DROWNED("\u0423\u0442\u043e\u043f\u043b\u0435\u043d\u043d\u0438\u043a", 50, 5400),
    MAGICIAN("\u041a\u043e\u043b\u0434\u0443\u043d", 55, 14400),
    DIE("\u0421\u043c\u0435\u0440\u0442\u044c", 60, 7200),
    RIDER("\u041d\u0430\u0435\u0437\u0434\u043d\u0438\u043a", 65, 14400),
    OUTLAW("\u0420\u0430\u0437\u0431\u043e\u0439\u043d\u0438\u043a", 70, 9000),
    MAGMA_SLIME("\u041b\u0430\u0432\u043e\u0432\u044b\u0439 \u043a\u0443\u0431", 75, 21600),
    WARDEN("\u0412\u0430\u0440\u0434\u0435\u043d", 80, 25200),
    GHOST_HUNTER("\u041f\u0440\u0438\u0437\u0440\u0430\u0447\u043d\u044b\u0439 \u043e\u0445\u043e\u0442\u043d\u0438\u043a", 90, 10800),
    BLACK_DRAGON("\u0427\u0451\u0440\u043d\u044b\u0439 \u0434\u0440\u0430\u043a\u043e\u043d", 95, 23400),
    GIANT("\u0413\u0438\u0433\u0430\u043d\u0442", 100, 12600),
    CURSED_LEGION("\u041f\u0440\u043e\u043a\u043b\u044f\u0442\u044b\u0439 \u043b\u0435\u0433\u0438\u043e\u043d", 105, 25200),
    MONSTER("\u041c\u043e\u043d\u0441\u0442\u0440", 110, 14400),
    NECROMANCER("\u041d\u0435\u043a\u0440\u043e\u043c\u0430\u043d\u0442", 115, 25200),
    DARKNESS_DEVOURER("\u041f\u043e\u0436\u0438\u0440\u0430\u0442\u0435\u043b\u044c \u0442\u044c\u043c\u044b", 120, 16200),
    MONSTER_2("\u0427\u0443\u0434\u043e\u0432\u0438\u0449\u0435", 125, 18000),
    OCTOPUS("\u041e\u043a\u0442\u043e\u043f\u0443\u0441", 130, 25200),
    SMITH("\u041a\u0443\u0437\u043d\u0435\u0446", 140, 18000),
    SHULKER("\u041c\u043e\u0433\u0443\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0439 \u0448\u0430\u043b\u043a\u0435\u0440", 150, 19800),
    CASTER("\u0417\u0430\u043a\u043b\u0438\u043d\u0430\u0442\u0435\u043b\u044c", 160, 19800),
    DIE_RIDER("\u0412\u0441\u0430\u0434\u043d\u0438\u043a", 170, 21600),
    KOBOLD("\u041a\u043e\u0431\u043e\u043b\u044c\u0434", 180, 25200),
    SAMURAI("\u0421\u0430\u043c\u0443\u0440\u0430\u0439", 190, 23400),
    DIE_LORD("\u041f\u043e\u0432\u0435\u043b\u0438\u0442\u0435\u043b\u044c \u043c\u0451\u0440\u0442\u0432\u044b\u0445", 200, 19800),
    SHADOW_LORD("\u0422\u0435\u043d\u0435\u0432\u043e\u0439 \u043b\u043e\u0440\u0434", 210, 25200),
    BIG_TURTLE("\u0413\u0438\u0433\u0430\u043d\u0442\u0441\u043a\u0430\u044f \u0447\u0435\u0440\u0435\u043f\u0430\u0445\u0430", 220, 25200),
    GOLIATH("\u0413\u043e\u043b\u0438\u0430\u0444", 230, 25200),
    DESTROYER("\u0420\u0430\u0437\u0440\u0443\u0448\u0438\u0442\u0435\u043b\u044c", 240, 19800),
    SNOW_MONSTER("\u0421\u043d\u0435\u0436\u043d\u044b\u0439 \u043c\u043e\u043d\u0441\u0442\u0440", 250, 3600),
    SCREAM("\u041a\u0440\u0438\u043a", 260, 25200),
    SPECTRAL_CUBE("\u0421\u043f\u0435\u043a\u0442\u0440\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0443\u0431", 270, 25200),
    SHADOW("\u0422\u0435\u043d\u044c", 280, 25200),
    CYNTHIA("\u0421\u0438\u043d\u0442\u0438\u044f", 290, 25200),
    MAGNUS("\u041c\u0430\u0433\u043d\u0443\u0441", 300, 25200),
    HELL_HERALD("\u0412\u0435\u0441\u0442\u043d\u0438\u043a \u0430\u0434\u0430", 310, 25200),
    HELL_HOUND("\u0426\u0435\u0440\u0431\u0435\u0440", 320, 28800),
    IFRIT("\u0418\u0444\u0440\u0438\u0442", 330, 25200),
    BAPHOMET("\u0411\u0430\u0444\u043e\u043c\u0435\u0442", 340, 0),
    PIGLIN("\u041f\u0438\u0433\u043b\u0438\u043d", 350, 25200),
    QUEEN_PIGLIN("\u041a\u043e\u0440\u043e\u043b\u0435\u0432\u0430 \u043f\u0438\u0433\u043b\u0438\u043d\u043e\u0432", 360, 25200),
    HOGLIN("\u0425\u043e\u0433\u043b\u0438\u043d", 370, 25200),
    ZOMBIE_PIGLIN("\u0417\u043e\u043c\u0431\u0438 \u043f\u0438\u0433\u043b\u0438\u043d", 380, 25200),
    BRUTAL_PIGLIN("\u0411\u0440\u0443\u0442\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0438\u0433\u043b\u0438\u043d", 390, 25200),
    MAGMA("\u041c\u0430\u0433\u043c\u0430", 400, 25200),
    ZOGLIN("\u0417\u043e\u0433\u043b\u0438\u043d", 410, 25200),
    HELL_KNIGHT("\u0410\u0434\u0441\u043a\u0438\u0439 \u0440\u044b\u0446\u0430\u0440\u044c", 410, 25200);

    private final String name;
    private final int level;
    private final long time;
    private static final List<String> medals;

    private BossType(String name, int level, int time) {
        this.name = name;
        this.level = level;
        this.time = (long)time * 1000L;
    }

    public static BossType getByName(String name) {
        name = Util.stripColor(name);
        for (String string : medals) {
            String string2 = " " + string;
            if (!name.contains(string2)) continue;
            name = name.split(string2)[0];
        }
        for (BossType type : BossType.values()) {
            if (!type.name.equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public long getTime() {
        return this.time;
    }

    static {
        medals = Arrays.asList("\ue124", "\ue125", "\ue126");
    }
}

