/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.impl.boss;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1707;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_476;
import net.minecraft.class_638;
import org.apache.commons.lang3.tuple.Pair;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.event.render.HudRenderEvent;
import ru.dargen.evoplus.feature.Feature;
import ru.dargen.evoplus.feature.impl.boss.BossRenderOrder;
import ru.dargen.evoplus.feature.impl.boss.BossType;
import ru.dargen.evoplus.feature.setting.BooleanSetting;
import ru.dargen.evoplus.feature.setting.RangeSetting;
import ru.dargen.evoplus.notify.Notification;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.common.CollectionUtil;
import ru.dargen.evoplus.util.diamondworld.DiamondWorldUtil;
import ru.dargen.evoplus.util.formatter.TimeFormatter;
import ru.dargen.evoplus.util.minecraft.ItemUtil;
import ru.dargen.evoplus.util.minecraft.Render;

public class BossTimerFeature
extends Feature {
    protected Map<BossType, Long> infoMap = new ConcurrentHashMap<BossType, Long>();
    protected BooleanSetting render = BooleanSetting.builder().name("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435").id("render").build();
    protected RangeSetting<Integer> width = RangeSetting.builder().name("\u0428\u0438\u0440\u0438\u043d\u0430").id("render-width").index(10).elements(CollectionUtil.intRange(10, 1000, 10)).build();
    protected RangeSetting<Integer> height = RangeSetting.builder().name("\u0412\u044b\u0441\u043e\u0442\u0430").id("render-height").index(10).elements(CollectionUtil.intRange(10, 1000, 10)).build();
    protected RangeSetting<Integer> scale = RangeSetting.builder().name("\u0420\u0430\u0437\u043c\u0435\u0440 (%)").id("render-scale").index(99).elements(CollectionUtil.intRange(1, 200, 2)).build();
    protected BooleanSetting messageOnReady = BooleanSetting.builder().name("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u0441\u043f\u0430\u0432\u043d\u0435").id("message").value(false).build();
    protected BooleanSetting notifyOnReady = BooleanSetting.builder().name("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0438 \u0441\u043f\u0430\u0432\u043d\u0435").id("notify").build();
    protected BooleanSetting clanChatOnReady = BooleanSetting.builder().name("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u0432 \u043a\u043b\u0430\u043d\u043e\u0432\u044b\u0439 \u0447\u0430\u0442 \u043f\u0440\u0438 \u0441\u043f\u0430\u0432\u043d\u0435").id("clan-chat").value(false).build();
    protected BooleanSetting menu = BooleanSetting.builder().name("\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0432 \u043c\u0435\u043d\u044e").id("menu").build();
    protected RangeSetting<BossRenderOrder> renderOrder = RangeSetting.builder().name("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u0440\u0438 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0438").id("sorting").elements(Arrays.asList(BossRenderOrder.values())).build();
    protected RangeSetting<Integer> minLevel = RangeSetting.builder().name("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0431\u043e\u0441\u0441\u0430").id("min-level").elements(Arrays.stream(BossType.values()).map(BossType::getLevel).collect(Collectors.toList())).build();
    protected RangeSetting<Integer> maxLevel = RangeSetting.builder().name("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0431\u043e\u0441\u0441\u0430").id("max-level").elements(Arrays.stream(BossType.values()).map(BossType::getLevel).collect(Collectors.toList())).index(BossType.values().length - 1).build();

    public BossTimerFeature() {
        super("\u0422\u0430\u0439\u043c\u0435\u0440 \u0431\u043e\u0441\u0441\u043e\u0432", "boss-timer");
        this.register();
    }

    @Override
    public void onRegister(EvoPlus mod) {
        mod.getTaskBus().runAsync(20L, 20L, task -> {
            if (!DiamondWorldUtil.isOnPrisonEvo()) {
                return;
            }
            for (BossType type : BossType.values()) {
                if (this.hasCooldown(type) || this.infoMap.remove((Object)type) == null || !DiamondWorldUtil.isOnPrisonEvo() || !this.inLevelBounds(type)) continue;
                if (this.notifyOnReady.getValue().booleanValue()) {
                    mod.getNotifyManager().notify(Notification.Type.CONFIRM, "\u00a7a\u0411\u043e\u0441\u0441 \u0432\u043e\u0437\u0440\u043e\u0436\u0434\u0435\u043d", 3, "\u00a76" + type.getName());
                }
                if (this.messageOnReady.getValue().booleanValue()) {
                    Util.printMessage("\u00a77[\u00a7eEvo\u00a76Plus\u00a77] \u00a7r\u00a7a\u0411\u043e\u0441\u0441 \u0432\u043e\u0437\u0440\u043e\u0436\u0434\u0435\u043d: \u00a76" + type.getName());
                }
                if (!this.clanChatOnReady.getValue().booleanValue()) continue;
                Util.sendMessage("@&a\u0411\u043e\u0441\u0441 \u0432\u043e\u0437\u0440\u043e\u0436\u0434\u0435\u043d: &6" + type.getName());
            }
            Pair<BossType, Long> info = this.getNearbyBossInfo();
            if (info != null) {
                this.infoMap.put((BossType)((Object)((Object)info.getKey())), BossTimerFeature.fixTime((Long)info.getValue()));
            }
        });
        mod.getEventBus().register(HudRenderEvent.class, event -> {
            if (!this.render.getValue().booleanValue() || !DiamondWorldUtil.isOnPrisonEvo()) {
                return;
            }
            class_4587 matrixStack = event.getMatrixStack();
            int[] index = new int[]{0};
            float scale = (float)this.scale.getValue().intValue() / 100.0f;
            Render.scaledRunner(matrixStack, scale, (__, ___) -> this.infoMap.entrySet().stream().filter(info -> this.hasCooldown((BossType)((Object)((Object)((Object)((Object)info.getKey()))))) && this.inLevelBounds((BossType)((Object)((Object)((Object)((Object)info.getKey())))))).sorted(this.renderOrder.getValue().getComparator()).forEach(info -> {
                long right = (Long)info.getValue() + ((BossType)((Object)((Object)((Object)((Object)info.getKey()))))).getTime() - System.currentTimeMillis();
                int n = index[0];
                index[0] = n + 1;
                Render.drawString(matrixStack, "\u00a76" + ((BossType)((Object)((Object)((Object)((Object)info.getKey()))))).getName() + "\u00a77 [\u00a7c" + ((BossType)((Object)((Object)((Object)((Object)info.getKey()))))).getLevel() + "\u00a77] - \u00a7a" + TimeFormatter.formatText(right), (int)(5.0f / scale + (float)this.width.getValue().intValue()), (int)((5.0f / scale + (float)this.height.getValue().intValue() + (float)(Render.getStringHeight() * n)) / scale), -1);
            }));
        });
        mod.getTaskBus().runAsync(10L, 10L, task -> {
            class_437 screen;
            if (DiamondWorldUtil.isOnPrisonEvo() && this.menu.getValue().booleanValue() && (screen = Util.getCurrentScreen()) instanceof class_476) {
                class_476 containerScreen = (class_476)screen;
                class_1707 container = (class_1707)containerScreen.method_17577();
                container.method_7602().forEach(item -> {
                    BossType type = BossType.getByName(ItemUtil.getDisplayName(item));
                    if (type == null || !this.inLevelBounds(type)) {
                        return;
                    }
                    Long info = this.infoMap.get((Object)type);
                    if (info != null) {
                        long right = type.getTime() + info - System.currentTimeMillis();
                        class_2561 text = class_2561.method_30163((String)("\u00a7f\u0420\u0435\u0441\u043f\u0430\u0432\u043d \u0447\u0435\u0440\u0435\u0437: \u00a7e" + TimeFormatter.formatText(right)));
                        List<class_2561> lore = ItemUtil.getTextLore(item);
                        if (lore.get(3).getString().contains("\u0420\u0435\u0441\u043f\u0430\u0432\u043d \u0447\u0435\u0440\u0435\u0437")) {
                            lore.set(3, text);
                        } else {
                            ArrayList<class_2561> newLore = new ArrayList<class_2561>();
                            for (int i = 0; i < lore.size(); ++i) {
                                if (i == 3) {
                                    newLore.add(text);
                                }
                                newLore.add(lore.get(i));
                            }
                            lore = newLore;
                        }
                        ItemUtil.setTextLore(item, lore);
                    }
                });
            }
        });
    }

    public int getMinLevel() {
        return Math.min(this.minLevel.getValue(), this.maxLevel.getValue());
    }

    public int getMaxLevel() {
        return Math.max(this.minLevel.getValue(), this.maxLevel.getValue());
    }

    public boolean inLevelBounds(BossType type) {
        return type.getLevel() <= this.getMaxLevel() && type.getLevel() >= this.getMinLevel();
    }

    public boolean hasCooldown(BossType type) {
        Long info = this.infoMap.get((Object)type);
        return info != null && info + type.getTime() >= System.currentTimeMillis();
    }

    public void putCooldown(BossType type) {
        this.infoMap.put(type, BossTimerFeature.fixTime(System.currentTimeMillis()));
    }

    public Pair<BossType, Long> getNearbyBossInfo() {
        if (Util.getWorld() == null) {
            return null;
        }
        List holograms = StreamSupport.stream(Spliterators.spliteratorUnknownSize(((class_638)Util.getWorld()).method_18112().iterator(), 0), false).filter(entity -> entity instanceof class_1531).map(class_1297::method_5476).map(class_2561::getString).map(Util::stripColor).collect(Collectors.toList());
        Optional<String> bossTypeLine = holograms.stream().filter(line -> line.startsWith("\u0411\u043e\u0441\u0441")).findFirst();
        Optional<String> respawnLine = holograms.stream().filter(line -> line.startsWith("\u0420\u0435\u0441\u043f\u0430\u0432\u043d")).findFirst();
        Optional<String> rightTimeLine = holograms.stream().filter(line -> line.contains("\u0447.") || line.contains("\u043c\u0438\u043d.") || line.contains("\u0441\u0435\u043a.")).findFirst();
        if (!(bossTypeLine.isPresent() && respawnLine.isPresent() && rightTimeLine.isPresent())) {
            return null;
        }
        BossType type = BossType.getByName(bossTypeLine.get().substring(5));
        if (type == null) {
            return null;
        }
        long rightTime = TimeFormatter.parseText(rightTimeLine.get());
        if (rightTime == 0L) {
            return null;
        }
        long killTime = System.currentTimeMillis() - (type.getTime() - rightTime);
        return Pair.of((Object)((Object)type), (Object)killTime);
    }

    private static long fixTime(long time) {
        return time / 1000L * 1000L;
    }

    public Map<BossType, Long> getInfoMap() {
        return this.infoMap;
    }

    public BooleanSetting getRender() {
        return this.render;
    }

    public RangeSetting<Integer> getWidth() {
        return this.width;
    }

    public RangeSetting<Integer> getHeight() {
        return this.height;
    }

    public RangeSetting<Integer> getScale() {
        return this.scale;
    }

    public BooleanSetting getMessageOnReady() {
        return this.messageOnReady;
    }

    public BooleanSetting getNotifyOnReady() {
        return this.notifyOnReady;
    }

    public BooleanSetting getClanChatOnReady() {
        return this.clanChatOnReady;
    }

    public BooleanSetting getMenu() {
        return this.menu;
    }

    public RangeSetting<BossRenderOrder> getRenderOrder() {
        return this.renderOrder;
    }
}

