/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature.impl;

import io.netty.util.internal.ConcurrentSet;
import java.util.Set;
import java.util.stream.Collectors;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.event.inventory.InventoryOpenEvent;
import ru.dargen.evoplus.event.inventory.InventorySlotUpdateEvent;
import ru.dargen.evoplus.feature.Feature;
import ru.dargen.evoplus.feature.setting.BooleanSetting;
import ru.dargen.evoplus.feature.setting.SetConfig;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.diamondworld.DiamondWorldUtil;
import ru.dargen.evoplus.util.minecraft.ItemUtil;

public class TeamWarFeature
extends Feature {
    protected Set<String> clanList = new ConcurrentSet();
    protected SetConfig<String> warList = SetConfig.builder().id("war-list").build();
    protected SetConfig<String> teamList = SetConfig.builder().id("team-list").build();
    protected BooleanSetting teamWarTagGlow = BooleanSetting.builder().id("team-war-tag-glow").name("\u041f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0430 \u0442\u0435\u0433\u0430 \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432/\u0432\u0440\u0430\u0433\u043e\u0432").build();
    protected BooleanSetting teamWarTabGlow = BooleanSetting.builder().id("team-war-tab-glow").name("\u041f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0430 \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432/\u0432\u0440\u0430\u0433\u043e\u0432 \u0432 \u0442\u0430\u0431\u0435").build();
    protected BooleanSetting glowClan = BooleanSetting.builder().id("glow-clan").name("\u041f\u043e\u0434\u0441\u0432\u0435\u0447\u0438\u0432\u0430\u0442\u044c \u0441\u043e\u043a\u043b\u0430\u043d\u043e\u0432\u0446\u0435\u0432").build();

    public TeamWarFeature() {
        super("\u0421\u043e\u044e\u0437\u043d\u0438\u043a\u0438/\u0412\u0440\u0430\u0433\u0438", "team-war");
        this.register();
    }

    @Override
    public void onRegister(EvoPlus mod) {
        mod.getEventBus().register(InventorySlotUpdateEvent.class, event -> {
            InventoryOpenEvent openEvent = event.getOpenEvent();
            if (openEvent != null && DiamondWorldUtil.isOnPrisonEvo() && event.getSlot() == 22 && Util.stripColor(openEvent.getNameString()).equalsIgnoreCase("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043a\u043b\u0430\u043d\u0435")) {
                Set members = ItemUtil.getStringLore(event.getStack()).stream().filter(line -> line.contains(")") && !line.contains(Util.getName())).map(String::toLowerCase).map(line -> Util.stripColor(line).split(" \\[")[0].replace("[\u0433\u043b.] ", "").replace("[\u043c.] ", "")).collect(Collectors.toSet());
                if (this.clanList.equals(members)) {
                    return;
                }
                this.clanList.clear();
                this.clanList.addAll(members);
                Util.printMessage("\u00a77[\u00a7eEvo\u00a76Plus\u00a77] \u00a7r\u00a7a\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043b\u0430\u043d\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d. \u041d\u0430\u0439\u0434\u0435\u043d\u043e " + members.size() + " \u0438\u0433\u0440\u043e\u043a\u043e\u0432.");
            }
        });
    }

    public String getColorForPlayer(String playerName) {
        return this.teamList.getValue().contains(playerName.toLowerCase()) || this.glowClan.getValue() != false && this.clanList.contains(playerName.toLowerCase()) ? "\u00a72" : (this.warList.getValue().contains(playerName.toLowerCase()) ? "\u00a7c" : null);
    }

    public String getTabColorForPlayer(String playerName) {
        return this.teamWarTabGlow.getValue() != false ? this.getColorForPlayer(playerName) : null;
    }

    public String getTagColorForPlayer(String playerName) {
        return this.teamWarTagGlow.getValue() != false ? this.getColorForPlayer(playerName) : null;
    }

    public Set<String> getClanList() {
        return this.clanList;
    }

    public SetConfig<String> getWarList() {
        return this.warList;
    }

    public SetConfig<String> getTeamList() {
        return this.teamList;
    }

    public BooleanSetting getTeamWarTagGlow() {
        return this.teamWarTagGlow;
    }

    public BooleanSetting getTeamWarTabGlow() {
        return this.teamWarTabGlow;
    }

    public BooleanSetting getGlowClan() {
        return this.glowClan;
    }
}

