/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.event.game.KeyboardEvent;
import ru.dargen.evoplus.feature.Feature;
import ru.dargen.evoplus.feature.FeaturesGuiScreen;
import ru.dargen.evoplus.util.Util;
import ru.dargen.evoplus.util.common.FileUtil;

public class FeatureManager {
    private final Set<Feature> features = new HashSet<Feature>();
    private final class_304 keyBinding = new class_304("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u043c\u0435\u043d\u044e", 344, "EvoPlus");
    private final JsonObject config;
    private final EvoPlus mod;

    public FeatureManager(EvoPlus mod) {
        this.mod = mod;
        KeyBindingHelper.registerKeyBinding((class_304)this.keyBinding);
        mod.getEventBus().register(KeyboardEvent.class, event -> {
            if (this.keyBinding.method_1417(event.getKey(), 0) && !Util.isOpenedScreen()) {
                new FeaturesGuiScreen().display();
            }
        });
        String configContent = FileUtil.getStringContent("features.cfg");
        JsonObject json = (JsonObject)mod.getPrettyGson().fromJson(configContent, JsonObject.class);
        this.config = json == null ? new JsonObject() : json;
        Runtime.getRuntime().addShutdownHook(new Thread(this::saveSettings));
    }

    protected void loadFeatureSettings(Feature feature) {
        JsonObject section = this.config.getAsJsonObject(feature.id);
        if (section != null && !section.isJsonNull()) {
            feature.getSettings().forEach(setting -> {
                JsonElement settingValue = section.get(setting.getId());
                if (settingValue != null && !section.isJsonNull()) {
                    setting.load(settingValue);
                }
            });
        }
    }

    public void saveSettings() {
        this.features.forEach(feature -> {
            JsonObject section = new JsonObject();
            feature.getSettings().forEach(setting -> section.add(setting.getId(), setting.unload()));
            this.config.add(feature.getId(), (JsonElement)section);
        });
        String configContent = this.mod.getPrettyGson().toJson((JsonElement)this.config);
        FileUtil.setStringContent("features.cfg", configContent);
    }

    public Set<Feature> getFeatures() {
        return this.features;
    }

    public class_304 getKeyBinding() {
        return this.keyBinding;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public EvoPlus getMod() {
        return this.mod;
    }
}

