/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.feature;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.feature.impl.MiscFeature;
import ru.dargen.evoplus.feature.impl.RenderFeature;
import ru.dargen.evoplus.feature.impl.TeamWarFeature;
import ru.dargen.evoplus.feature.impl.boss.BossTimerFeature;
import ru.dargen.evoplus.feature.impl.staff.StaffTimerFeature;
import ru.dargen.evoplus.feature.impl.stats.StatsFeature;
import ru.dargen.evoplus.feature.setting.Setting;
import ru.dargen.evoplus.gui.GuiElement;

public abstract class Feature {
    public static StatsFeature STATS_FEATURE;
    public static BossTimerFeature BOSS_TIMER_FEATURE;
    public static StaffTimerFeature STAFF_TIMER_FEATURE;
    public static TeamWarFeature TEAM_WAR_FEATURE;
    public static RenderFeature RENDER_FEATURE;
    public static MiscFeature MISC_FEATURE;
    protected final String name;
    protected final String id;
    protected final List<Setting<?>> settings = new LinkedList();

    public Feature(String name, String id) {
        this.name = name;
        this.id = id;
    }

    protected final void register() {
        Arrays.stream(this.getClass().getDeclaredFields()).map(field -> {
            try {
                field.setAccessible(true);
                Object value = field.get(Modifier.isStatic(field.getModifiers()) ? null : this);
                return value instanceof Setting ? (Setting)value : null;
            }
            catch (Throwable t) {
                EvoPlus.instance().getLogger().error("Error while get setting field value", t);
                return null;
            }
        }).filter(Objects::nonNull).forEach(this.settings::add);
        EvoPlus.instance().getFeatureManager().getFeatures().add(this);
        EvoPlus.instance().getFeatureManager().loadFeatureSettings(this);
        this.onRegister(EvoPlus.instance());
    }

    public List<GuiElement> getGuiElements() {
        return this.settings.stream().map(Setting::getElement).collect(Collectors.toList());
    }

    public void onRegister(EvoPlus mod) {
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public List<Setting<?>> getSettings() {
        return this.settings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<Setting<?>> this$settings = this.getSettings();
        List<Setting<?>> other$settings = other.getSettings();
        return !(this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Feature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<Setting<?>> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        return result;
    }

    public String toString() {
        return "Feature(name=" + this.getName() + ", id=" + this.getId() + ", settings=" + this.getSettings() + ")";
    }
}

