/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.event.Event;

public final class EventBus {
    private final Map<Class<? extends Event>, Set<Consumer<Event>>> handlerLists = new ConcurrentHashMap<Class<? extends Event>, Set<Consumer<Event>>>();
    private final EvoPlus mod;

    public EventBus(EvoPlus mod) {
        this.mod = mod;
    }

    public <E extends Event> void register(Class<E> eventClass, Consumer<E> handler) {
        this.handlerLists.computeIfAbsent(eventClass, __ -> new HashSet()).add(handler);
    }

    public <E extends Event> Set<Consumer<Event>> getHandlerList(Class<E> eventClass) {
        return this.handlerLists.getOrDefault(eventClass, Collections.emptySet());
    }

    public <E extends Event> E fireEvent(E event) {
        Class<?> eventClass = event.getClass();
        Set<Consumer<Event>> handlerList = this.getHandlerList(eventClass);
        handlerList.forEach(handler -> {
            try {
                handler.accept(event);
            }
            catch (Throwable t) {
                this.mod.getLogger().error("Error while handle event " + eventClass.getName(), t);
            }
        });
        return event;
    }
}

