/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.command.parameter.type;

import ru.dargen.evoplus.command.CommandParseException;
import ru.dargen.evoplus.command.parameter.type.Type;

public class TypeTime
implements Type<Long> {
    private Long min = Long.MIN_VALUE;
    private Long max = Long.MAX_VALUE;

    @Override
    public Long parse(String input) throws CommandParseException {
        long out;
        try {
            out = Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            int mp = this.parseMp(input.substring(input.length() - 1));
            try {
                out = Long.parseLong(input.substring(0, input.length() - 1)) * (long)mp;
            }
            catch (NumberFormatException exc) {
                throw new CommandParseException("\u00a7c" + input + " \u00a7f\u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c");
            }
            catch (CommandParseException exc) {
                throw e;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new CommandParseException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c");
        }
        if (out > this.max) {
            throw new CommandParseException("\u0412\u0440\u0435\u043c\u044f \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u00a7c" + this.max + "\u00a7f \u0441\u0435\u043a.");
        }
        if (out < this.min) {
            throw new CommandParseException("\u0412\u0440\u0435\u043c\u044f \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u00a7c" + this.min + "\u00a7f \u0441\u0435\u043a.");
        }
        return out;
    }

    public int parseMp(String mp) {
        switch (mp) {
            case "s": {
                return 1;
            }
            case "m": {
                return 60;
            }
            case "h": {
                return 3600;
            }
            case "d": 
            case "D": {
                return 86400;
            }
            case "M": {
                return 2592000;
            }
            case "Y": {
                return 31536000;
            }
        }
        throw new CommandParseException("\u041d\u0435\u0438\u0437\u0432\u0435\u0437\u0442\u043d\u044b\u0439 \u043c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u00a7c" + mp);
    }

    public TypeTime(Long min, Long max) {
        this.min = min;
        this.max = max;
    }

    public TypeTime() {
    }
}

