/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.command.context;

import java.util.List;
import ru.dargen.evoplus.command.Command;
import ru.dargen.evoplus.command.context.CommandContext;

public class CommandContextImpl
implements CommandContext {
    private final Command command;
    private final List<String> originalArgs;
    private final List<Object> args;

    @Override
    public boolean hasArg(int index) {
        return this.args.size() - 1 >= index;
    }

    @Override
    public <T> T getArg(int index) {
        return (T)(this.hasArg(index) ? this.args.get(index) : null);
    }

    @Override
    public void sendMessage(String message, Object ... obj) {
        this.command.sendMessage(message, obj);
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    @Override
    public List<String> getOriginalArgs() {
        return this.originalArgs;
    }

    @Override
    public List<Object> getArgs() {
        return this.args;
    }

    public CommandContextImpl(Command command, List<String> originalArgs, List<Object> args) {
        this.command = command;
        this.originalArgs = originalArgs;
        this.args = args;
    }

    public static class ContextBuilder {
        private final Command command;
        private List<String> originalArgs;
        private List<Object> args;

        public CommandContext build() {
            return new CommandContextImpl(this.command, this.originalArgs, this.args);
        }

        public ContextBuilder originalArgs(List<String> originalArgs) {
            this.originalArgs = originalArgs;
            return this;
        }

        public ContextBuilder args(List<Object> args) {
            this.args = args;
            return this;
        }

        protected ContextBuilder(Command command) {
            this.command = command;
        }
    }
}

