/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.command.commands;

import ru.dargen.evoplus.command.Command;
import ru.dargen.evoplus.command.context.CommandContext;
import ru.dargen.evoplus.command.parameter.Parameter;
import ru.dargen.evoplus.command.parameter.type.TypeString;
import ru.dargen.evoplus.feature.Feature;
import ru.dargen.evoplus.feature.impl.TeamWarFeature;

public class TeamCommand
extends Command {
    public TeamCommand() {
        super("team", "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u043e\u043c \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432", "t");
        this.subCommand(new TeamListCommand());
        this.subCommand(new TeamAddCommand());
        this.subCommand(new TeamRemoveCommand());
        this.subCommand(new TeamClearCommand());
    }

    private TeamWarFeature getFeature() {
        return Feature.TEAM_WAR_FEATURE;
    }

    @Override
    public void execute(CommandContext ctx) {
        ctx.sendMessage(this.getUsage(), new Object[0]);
    }

    public class TeamListCommand
    extends Command {
        public TeamListCommand() {
            super("list", "\u0421\u043f\u0438\u0441\u043e\u043a \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432", new String[0]);
        }

        @Override
        public void execute(CommandContext ctx) {
            Object teamList = TeamCommand.this.getFeature().getTeamList().getValue();
            if (teamList.isEmpty()) {
                ctx.sendMessage("\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432.", new Object[0]);
            } else {
                ctx.sendMessage("\u00a7a\u0421\u043f\u0438\u0441\u043e\u043a \u0432\u0430\u0448\u0438\u0445 \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432 - \u00a7f%s\u00a7a.", String.join((CharSequence)"\u00a7a, \u00a7f", (Iterable<? extends CharSequence>)teamList));
            }
        }
    }

    public class TeamAddCommand
    extends Command {
        public TeamAddCommand() {
            super("add", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u0430", new String[0]);
            this.parameter(new Parameter<TypeString>("\u041d\u0438\u043a", new TypeString()));
        }

        @Override
        public void execute(CommandContext ctx) {
            String name = ((String)ctx.getArg(0)).toLowerCase();
            Object warList = TeamCommand.this.getFeature().getWarList().getValue();
            Object teamList = TeamCommand.this.getFeature().getTeamList().getValue();
            if (teamList.contains(name)) {
                ctx.sendMessage("\u00a7c\u0418\u0433\u0440\u043e\u043a \u0443\u0436\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u043c.", new Object[0]);
            } else {
                boolean war = warList.remove(name);
                teamList.add(name);
                ctx.sendMessage("\u00a7a\u0422\u0435\u043f\u0435\u0440\u044c \u0438\u0433\u0440\u043e\u043a \u00a7e%s\u00a7a - \u0432\u0430\u0448 \u0441\u043e\u044e\u0437\u043d\u0438\u043a. %s", name, war ? "\u00a7c\u041f\u0440\u0435\u0436\u0434\u0435 \u043e\u043d \u0431\u044b\u043b \u0432\u0430\u0448\u0438\u043c \u0432\u0440\u0430\u0433\u043e\u043c!" : "");
            }
        }
    }

    public class TeamRemoveCommand
    extends Command {
        public TeamRemoveCommand() {
            super("remove", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u0430", new String[0]);
            this.parameter(new Parameter<TypeString>("\u041d\u0438\u043a", new TypeString()));
        }

        @Override
        public void execute(CommandContext ctx) {
            String name = ((String)ctx.getArg(0)).toLowerCase();
            Object teamList = TeamCommand.this.getFeature().getTeamList().getValue();
            if (!teamList.contains(name)) {
                ctx.sendMessage("\u00a7c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u043c.", new Object[0]);
            } else {
                teamList.remove(name);
                ctx.sendMessage("\u00a7c\u0418\u0433\u0440\u043e\u043a \u00a7e%s\u00a7c \u0443\u0434\u0430\u043b\u0435\u043d \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432.", name);
            }
        }
    }

    public class TeamClearCommand
    extends Command {
        public TeamClearCommand() {
            super("clear", "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432", new String[0]);
        }

        @Override
        public void execute(CommandContext ctx) {
            Object teamList = TeamCommand.this.getFeature().getTeamList().getValue();
            teamList.clear();
            ctx.sendMessage("\u00a7a\u0421\u043f\u0438\u0441\u043e\u043a \u0441\u043e\u044e\u0437\u043d\u0438\u043a\u043e\u0432 \u043e\u0447\u0438\u0449\u0435\u043d.", new Object[0]);
        }
    }
}

