/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ru.dargen.evoplus.EvoPlus;
import ru.dargen.evoplus.command.Command;
import ru.dargen.evoplus.event.chat.ChatSendEvent;

public class CommandManager {
    private final Map<String, Command> registeredCommands = new HashMap<String, Command>();

    public CommandManager(EvoPlus mod) {
        mod.getEventBus().register(ChatSendEvent.class, event -> {
            String text = event.getText();
            if (!text.startsWith("/")) {
                return;
            }
            String[] args = text.split(" ");
            String name = args[0].toLowerCase().substring(1);
            for (Command command : this.registeredCommands.values()) {
                if (!command.getName().equalsIgnoreCase(name) && !command.getAliases().contains(name)) continue;
                command.handle(args.length == 1 ? new String[]{} : Arrays.copyOfRange(args, 1, args.length));
                event.setCancelled(true);
                break;
            }
        });
    }

    public void registerCommands(Command ... commands) {
        Arrays.stream(commands).forEach(this::registerCommand);
    }

    public void registerCommand(Command command) {
        this.registeredCommands.put(command.getName().toLowerCase(), command);
    }

    public Map<String, Command> getRegisteredCommands() {
        return this.registeredCommands;
    }
}

