/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import ru.dargen.evoplus.command.CommandParseException;
import ru.dargen.evoplus.command.context.CommandContext;
import ru.dargen.evoplus.command.parameter.Parameter;
import ru.dargen.evoplus.util.Util;

public abstract class Command {
    protected final List<Command> subCommands = new LinkedList<Command>();
    protected final List<Parameter<?>> parameters = new LinkedList();
    protected final String name;
    protected String prefix = "\u00a77[\u00a7eEvo\u00a76Plus\u00a77] \u00a7r";
    protected String description;
    protected List<String> aliases;

    public Command(String name) {
        this(name, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430", new String[0]);
    }

    public Command(String name, String description, String ... aliases) {
        this.name = name;
        this.description(description).aliases(aliases);
    }

    public abstract void execute(CommandContext var1);

    public final Command aliases(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : aliases;
        return this;
    }

    public final Command aliases(String ... aliases) {
        return this.aliases(Arrays.asList(aliases));
    }

    public final Command description(String description) {
        this.description = description == null ? "" : description;
        return this;
    }

    public final Command prefix(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
        return this;
    }

    public final Command subCommand(Command subCommand) {
        this.subCommands.add(subCommand);
        return this;
    }

    public final Command parameter(Parameter<?> parameter) {
        if (!this.parameters.isEmpty() && !this.parameters.get(this.parameters.size() - 1).isRequired() && parameter.isRequired()) {
            throw new IllegalStateException("can`t add required parameter after non-required");
        }
        this.parameters.add(parameter);
        return this;
    }

    protected final void handle(String[] args) {
        if (args.length > 0) {
            String subCommand = args[0];
            for (Command command : this.subCommands) {
                if (!command.getName().equalsIgnoreCase(subCommand) && !command.getAliases().stream().anyMatch(a -> a.equalsIgnoreCase(subCommand))) continue;
                command.handle(Arrays.copyOfRange(args, 1, args.length));
                return;
            }
        }
        LinkedList<Object> parsedParameters = new LinkedList<Object>();
        try {
            for (int i = 0; i < this.parameters.size(); ++i) {
                Parameter<?> param = this.parameters.get(i);
                if (args.length - 1 < i) {
                    if (!param.isRequired()) continue;
                    throw new CommandParseException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u00a7c" + param.getName());
                }
                parsedParameters.add(param.getType().parse(args[i]));
            }
            this.execute(CommandContext.builder(this).args(parsedParameters).originalArgs(Arrays.asList(args)).build());
        }
        catch (CommandParseException e) {
            this.sendMessage(e.getMessage(), new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String getUsage() {
        StringBuilder builder = new StringBuilder("\u00a7f/").append(this.name).append(" ");
        this.getParameters().stream().map(parameter -> "\u00a77" + (parameter.isRequired() ? "<" : "[") + "\u00a7a" + parameter.getName().toUpperCase() + "\u00a77" + (parameter.isRequired() ? "> " : "] ")).forEach(builder::append);
        builder.append("\u00a77- ").append(this.description);
        if (!this.subCommands.isEmpty()) {
            builder.append("\n").append(this.prefix).append("\u00a7f/").append(this.name);
            builder.append(" \u00a77[\u00a7a");
            builder.append(this.subCommands.stream().map(Command::getName).collect(Collectors.joining("\u00a77/\u00a7a")));
            builder.append("\u00a77]");
        }
        return builder.toString();
    }

    public Command sendMessage(String message, Object ... params) {
        Util.printMessage(String.format(this.prefix + message, params).replace("&", "\u00a7"));
        return this;
    }

    public List<Command> getSubCommands() {
        return this.subCommands;
    }

    public List<Parameter<?>> getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAliases() {
        return this.aliases;
    }
}

