/*
 * Decompiled with CFR 0.152.
 */
package ru.dargen.evoplus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.dargen.evoplus.command.CommandManager;
import ru.dargen.evoplus.command.commands.HelpCommand;
import ru.dargen.evoplus.command.commands.TeamCommand;
import ru.dargen.evoplus.command.commands.WarCommand;
import ru.dargen.evoplus.event.EventBus;
import ru.dargen.evoplus.feature.Feature;
import ru.dargen.evoplus.feature.FeatureManager;
import ru.dargen.evoplus.feature.impl.MiscFeature;
import ru.dargen.evoplus.feature.impl.RenderFeature;
import ru.dargen.evoplus.feature.impl.TeamWarFeature;
import ru.dargen.evoplus.feature.impl.boss.BossTimerFeature;
import ru.dargen.evoplus.feature.impl.staff.StaffTimerFeature;
import ru.dargen.evoplus.feature.impl.stats.StatsFeature;
import ru.dargen.evoplus.notify.NotificationsManager;
import ru.dargen.evoplus.task.TaskBus;
import ru.dargen.evoplus.util.diamondworld.EvoStatistic;

public class EvoPlus
implements ModInitializer {
    public static final String NAME = "\u00a7eEvo\u00a76Plus";
    public static final String PREFIX = "\u00a77[\u00a7eEvo\u00a76Plus\u00a77] \u00a7r";
    protected static EvoPlus instance;
    public static final File folder;
    private static final String version;
    private final Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
    private final Gson gson = new GsonBuilder().create();
    private final Logger logger = LogManager.getLogger((String)"EvoPlus");
    private TaskBus taskBus;
    private EventBus eventBus;
    private EvoStatistic stats;
    private FeatureManager featureManager;
    private CommandManager commandManager;
    private NotificationsManager notifyManager;

    public void onInitialize() {
        instance = this;
        this.taskBus = new TaskBus(this);
        this.eventBus = new EventBus(this);
        this.stats = new EvoStatistic(this);
        this.featureManager = new FeatureManager(this);
        this.commandManager = new CommandManager(this);
        this.notifyManager = new NotificationsManager(this);
        this.commandManager.registerCommands(new TeamCommand(), new WarCommand(), new HelpCommand());
        Feature.STATS_FEATURE = new StatsFeature();
        Feature.BOSS_TIMER_FEATURE = new BossTimerFeature();
        Feature.STAFF_TIMER_FEATURE = new StaffTimerFeature();
        Feature.TEAM_WAR_FEATURE = new TeamWarFeature();
        Feature.RENDER_FEATURE = new RenderFeature();
        Feature.MISC_FEATURE = new MiscFeature();
    }

    public Gson getPrettyGson() {
        return this.prettyGson;
    }

    public Gson getGson() {
        return this.gson;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TaskBus getTaskBus() {
        return this.taskBus;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public EvoStatistic getStats() {
        return this.stats;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public NotificationsManager getNotifyManager() {
        return this.notifyManager;
    }

    public static EvoPlus instance() {
        return instance;
    }

    public static File folder() {
        return folder;
    }

    public static String version() {
        return version;
    }

    static {
        folder = new File(System.getProperty("user.dir"), "evo-plus");
        version = ((ModContainer)FabricLoader.INSTANCE.getModContainer("evo-plus").get()).getMetadata().getVersion().getFriendlyString();
    }
}

